/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.hybrid;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.sync.DataSyncOperationType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SyncHybridOperationDetails
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String spaceName;
    private DataSyncOperationType dataSyncOperationType;
    private SpaceDocument dataDocument;
    private Object dataObject;
    private IEntryPacket entryPacket;

    public SyncHybridOperationDetails() {
    }

    public SyncHybridOperationDetails(String spaceName, DataSyncOperationType dataSyncOperationType, IEntryPacket entryPacket) {
        this.spaceName = spaceName;
        this.dataSyncOperationType = dataSyncOperationType;
        this.entryPacket = entryPacket.clone();
        this.entryPacket.setSerializeTypeDesc(true);
    }

    public SpaceDocument getDataDocument() {
        if (this.dataDocument == null) {
            this.dataDocument = (SpaceDocument)this.entryPacket.toObject(QueryResultTypeInternal.DOCUMENT_ENTRY);
        }
        return this.dataDocument;
    }

    public Object getDataObject() {
        if (this.dataObject == null) {
            this.dataObject = this.entryPacket.toObject(QueryResultTypeInternal.OBJECT_JAVA);
        }
        return this.dataObject;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public String getUid() {
        return this.entryPacket.getUID();
    }

    public DataSyncOperationType getDataSyncOperationType() {
        return this.dataSyncOperationType;
    }

    public String toString() {
        return "SyncHybridOperationDetails{spaceName='" + this.spaceName + '\'' + ", uid='" + this.getUid() + '\'' + ", dataSyncOperationType=" + (Object)((Object)this.dataSyncOperationType) + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString(out, this.spaceName);
        IOUtils.writeObject(out, (Object)this.dataSyncOperationType);
        IOUtils.writeObject(out, this.entryPacket);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.spaceName = IOUtils.readString(in);
        this.dataSyncOperationType = (DataSyncOperationType)((Object)IOUtils.readObject(in));
        this.entryPacket = (IEntryPacket)IOUtils.readObject(in);
    }
}

