/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.hybrid;

import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.sync.SynchronizationStorageAdapter;
import com.gigaspaces.internal.sync.hybrid.SyncHybridExceptionOrigin;
import com.gigaspaces.internal.sync.hybrid.SyncHybridSAException;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.errors.BlobStoreErrorsHandler;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreStorageAdapter;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreStorageAdapterClassInfo;
import com.j_spaces.core.cache.blobStore.sadapter.IBlobStoreStorageAdapter;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.IStorageAdapter;
import com.j_spaces.core.sadapter.MemorySA;
import com.j_spaces.core.sadapter.SAException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

public class SyncHybridStorageAdapter
implements IStorageAdapter,
IBlobStoreStorageAdapter {
    private static final Logger logger = Logger.getLogger("com.gigaspaces.persistent");
    private final CacheManager cacheManager;
    private final SynchronizationStorageAdapter synchronizationStorageAdapter;
    private final BlobStoreStorageAdapter blobStoreStorageAdapter;

    public SyncHybridStorageAdapter(CacheManager cacheManager, IStorageAdapter syncSA, IStorageAdapter blobStoreSA) {
        this.cacheManager = cacheManager;
        if (!(syncSA instanceof SynchronizationStorageAdapter) || !(blobStoreSA instanceof BlobStoreStorageAdapter)) {
            throw new IllegalStateException("SyncHybrid is supported only with a combination of SynchronizationStorageAdapter and BlobStoreStorageAdapter");
        }
        this.synchronizationStorageAdapter = (SynchronizationStorageAdapter)syncSA;
        this.blobStoreStorageAdapter = (BlobStoreStorageAdapter)blobStoreSA;
        this.validateConfiguration(syncSA);
    }

    private void validateConfiguration(IStorageAdapter syncSA) {
        if (syncSA instanceof MemorySA) {
            throw new IllegalStateException("SyncHybrid without SpaceSynchronizationEndpoint is not supported");
        }
        if (!this.cacheManager.isBlobStoreCachePolicy()) {
            throw new IllegalStateException("SyncHybrid without blobstore is not supported");
        }
        if (this.cacheManager.isPersistentBlobStore()) {
            throw new IllegalStateException("SyncHybrid with persistent blobstore is not supported, please set persistent=false in blobstore handler");
        }
        if (this.cacheManager.getEngine().hasMirror()) {
            throw new IllegalStateException("SyncHybrid with mirror service is not supported");
        }
        if (this.cacheManager.useBlobStoreBulks()) {
            throw new IllegalStateException("SyncHybrid with blobstore bulks is not supported");
        }
        if (this.synchronizationStorageAdapter.getSynchronizationInterceptor() == null) {
            throw new IllegalStateException("SyncHybrid without space-sync-endpoint is not supported, please provide space-sync-endpoint");
        }
    }

    @Override
    public BlobStoreStorageAdapterClassInfo getBlobStoreStorageAdapterClassInfo(String typeName) {
        return this.blobStoreStorageAdapter.getBlobStoreStorageAdapterClassInfo(typeName);
    }

    @Override
    public boolean hasAnotherInitialLoadSource() {
        return false;
    }

    @Override
    public void initialize() throws SAException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("[" + this.cacheManager.getEngine().getFullSpaceName() + "] Initializing sync hybrid storage adapter");
        }
        this.synchronizationStorageAdapter.initialize();
        this.blobStoreStorageAdapter.initialize();
    }

    @Override
    public ISAdapterIterator initialLoad(Context context, ITemplateHolder template) throws SAException {
        return this.synchronizationStorageAdapter.initialLoad(context, template);
    }

    @Override
    public void insertEntry(Context context, IEntryHolder entryHolder, boolean origin, boolean shouldReplicate) throws SAException {
        if (origin) {
            try {
                this.synchronizationStorageAdapter.insertEntry(context, entryHolder, true, shouldReplicate);
            }
            catch (SAException ex) {
                this.handleFailure(context, entryHolder, true, 1, ex);
            }
        }
        try {
            this.blobStoreStorageAdapter.insertEntry(context, entryHolder, origin, shouldReplicate);
        }
        catch (Exception ex) {
            this.handleFailure(context, entryHolder, false, 1, ex);
        }
    }

    @Override
    public void updateEntry(Context context, IEntryHolder updatedEntry, boolean updateRedoLog, boolean origin, boolean[] partialUpdateValuesIndicators) throws SAException {
        if (origin) {
            try {
                this.synchronizationStorageAdapter.updateEntry(context, updatedEntry, updateRedoLog, true, partialUpdateValuesIndicators);
            }
            catch (SAException ex) {
                this.handleFailure(context, updatedEntry, true, 7, ex);
            }
        }
        try {
            this.blobStoreStorageAdapter.updateEntry(context, updatedEntry, updateRedoLog, origin, partialUpdateValuesIndicators);
        }
        catch (Exception ex) {
            this.handleFailure(context, updatedEntry, false, 7, ex);
        }
    }

    @Override
    public void removeEntry(Context context, IEntryHolder entryHolder, boolean origin, boolean fromLeaseExpiration, boolean shouldReplicate) throws SAException {
        if (origin) {
            try {
                this.synchronizationStorageAdapter.removeEntry(context, entryHolder, true, fromLeaseExpiration, shouldReplicate);
            }
            catch (SAException ex) {
                this.handleFailure(context, entryHolder, true, 4, ex);
            }
        }
        try {
            this.blobStoreStorageAdapter.removeEntry(context, entryHolder, origin, fromLeaseExpiration, shouldReplicate);
        }
        catch (Exception ex) {
            this.handleFailure(context, entryHolder, false, 4, ex);
        }
    }

    @Override
    public void prepare(Context context, ServerTransaction xtn, ArrayList<IEntryHolder> pLocked, boolean singleParticipant, Map<String, Object> partialUpdatesAndInPlaceUpdatesInfo, boolean shouldReplicate) throws SAException {
        try {
            this.synchronizationStorageAdapter.prepare(context, xtn, pLocked, singleParticipant, partialUpdatesAndInPlaceUpdatesInfo, shouldReplicate);
        }
        catch (Exception ex) {
            throw new SyncHybridSAException(ex, context.getSyncHybridOperationDetails(), SyncHybridExceptionOrigin.SYNCHRONIZATION);
        }
        try {
            this.blobStoreStorageAdapter.prepare(context, xtn, pLocked, singleParticipant, partialUpdatesAndInPlaceUpdatesInfo, shouldReplicate);
        }
        catch (Exception ex) {
            throw new SyncHybridSAException(ex, context.getSyncHybridOperationDetails(), SyncHybridExceptionOrigin.BLOBSTORE);
        }
    }

    @Override
    public void rollback(ServerTransaction xtn, boolean anyUpdates) throws SAException {
        this.synchronizationStorageAdapter.rollback(xtn, anyUpdates);
        this.blobStoreStorageAdapter.rollback(xtn, anyUpdates);
    }

    @Override
    public IEntryHolder getEntry(Context context, Object uid, String classname, IEntryHolder template) throws SAException {
        return this.blobStoreStorageAdapter.getEntry(context, uid, classname, template);
    }

    @Override
    public Map<String, IEntryHolder> getEntries(Context context, Object[] ids, String typeName, IEntryHolder[] templates) throws SAException {
        return this.blobStoreStorageAdapter.getEntries(context, ids, typeName, templates);
    }

    @Override
    public ISAdapterIterator<IEntryHolder> makeEntriesIter(ITemplateHolder template, long SCNFilter, long leaseFilter, IServerTypeDesc[] subClasses) throws SAException {
        return this.blobStoreStorageAdapter.makeEntriesIter(template, SCNFilter, leaseFilter, subClasses);
    }

    @Override
    public void commit(ServerTransaction xtn, boolean anyUpdates) throws SAException {
        this.synchronizationStorageAdapter.commit(xtn, anyUpdates);
        this.blobStoreStorageAdapter.commit(xtn, anyUpdates);
    }

    @Override
    public int count(ITemplateHolder template, String[] subClasses) throws SAException {
        return this.blobStoreStorageAdapter.count(template, subClasses);
    }

    @Override
    public void shutDown() throws SAException {
        this.synchronizationStorageAdapter.shutDown();
        this.blobStoreStorageAdapter.shutDown();
    }

    @Override
    public boolean isReadOnly() {
        return this.blobStoreStorageAdapter.isReadOnly();
    }

    @Override
    public boolean supportsExternalDB() {
        return this.blobStoreStorageAdapter.supportsExternalDB();
    }

    @Override
    public boolean supportsPartialUpdate() {
        return this.blobStoreStorageAdapter.supportsPartialUpdate();
    }

    @Override
    public boolean supportsGetEntries() {
        return this.blobStoreStorageAdapter.supportsGetEntries();
    }

    @Override
    public void introduceDataType(ITypeDesc typeDesc) {
        this.synchronizationStorageAdapter.introduceDataType(typeDesc);
        this.blobStoreStorageAdapter.introduceDataType(typeDesc);
    }

    @Override
    public SpaceSynchronizationEndpoint getSynchronizationInterceptor() {
        return this.synchronizationStorageAdapter.getSynchronizationInterceptor();
    }

    @Override
    public Class<?> getDataClass() {
        return this.synchronizationStorageAdapter.getDataClass();
    }

    @Override
    public void addIndexes(String typeName, SpaceIndex[] indexes) {
        this.synchronizationStorageAdapter.addIndexes(typeName, indexes);
        this.blobStoreStorageAdapter.addIndexes(typeName, indexes);
    }

    @Override
    public boolean shouldRevertOpOnBlobStoreError() {
        return true;
    }

    private void handleFailure(Context context, IEntryHolder entryHolder, boolean db, int spaceOperation, Exception ex) throws SyncHybridSAException {
        String operationType = null;
        SyncHybridExceptionOrigin exceptionOrigin = db ? SyncHybridExceptionOrigin.SYNCHRONIZATION : SyncHybridExceptionOrigin.BLOBSTORE;
        switch (spaceOperation) {
            case 1: {
                if (db) {
                    BlobStoreErrorsHandler.onFailedWrite(this.cacheManager, context, ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart(), entryHolder);
                }
                operationType = "write";
                break;
            }
            case 7: {
                if (db) {
                    BlobStoreErrorsHandler.onFailedUpdate(this.cacheManager, context, ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart(), entryHolder);
                }
                operationType = "update";
                break;
            }
            case 4: {
                if (db) {
                    BlobStoreErrorsHandler.onFailedRemove(this.cacheManager, context, ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart(), entryHolder);
                }
                operationType = "remove";
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.throwing(this.getClass().getName(), "failed to execute " + operationType + " operation on " + (Object)((Object)exceptionOrigin), ex);
        }
        throw new SyncHybridSAException(ex, context.getSyncHybridOperationDetails(), exceptionOrigin);
    }
}

