/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.sync.DataSyncOperationType;
import com.j_spaces.sadapter.datasource.IDataConverter;
import com.j_spaces.sadapter.datasource.InternalBulkItem;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class MirrorBulkDataItem
implements InternalBulkItem {
    private final short _operation;
    protected final IEntryPacket _dataPacket;
    protected IDataConverter<IEntryPacket> _converter;

    public MirrorBulkDataItem(IEntryPacket dataPacket, short operation) {
        this._operation = operation;
        this._dataPacket = dataPacket;
    }

    @Override
    public Object getItem() {
        if (this._converter != null) {
            return this._converter.toObject(this._dataPacket);
        }
        return this;
    }

    @Override
    public short getOperation() {
        return this._operation;
    }

    public IDataConverter<IEntryPacket> getConverter() {
        return this._converter;
    }

    @Override
    public void setConverter(IDataConverter<IEntryPacket> converter) {
        this._converter = converter;
    }

    @Override
    public IEntryPacket toEntryPacket() {
        return this._dataPacket;
    }

    public String toString() {
        String operation = null;
        switch (this._operation) {
            case 1: {
                operation = "REMOVE";
                break;
            }
            case 2: {
                operation = "UPDATE";
                break;
            }
            case 3: {
                operation = "WRITE";
                break;
            }
            case 4: {
                operation = "PARTIAL UPDATE";
                break;
            }
            default: {
                operation = "UNKNOWN";
            }
        }
        return "BulkDataItem<Op: " + operation + ", " + this._dataPacket.toString() + ">";
    }

    @Override
    public String getTypeName() {
        return this._dataPacket.getTypeName();
    }

    @Override
    public String getIdPropertyName() {
        return this._dataPacket.getTypeDescriptor().getIdPropertyName();
    }

    @Override
    public Object getIdPropertyValue() {
        return this._dataPacket.getID();
    }

    @Override
    public boolean supportsGetSpaceId() {
        return true;
    }

    @Override
    public Object getSpaceId() {
        return this.getIdPropertyValue();
    }

    @Override
    public Map<String, Object> getItemValues() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        ITypeDesc typeDesc = this._dataPacket.getTypeDescriptor();
        for (int i = 0; i < typeDesc.getNumOfFixedProperties(); ++i) {
            props.put(typeDesc.getFixedProperty(i).getName(), this._dataPacket.getFieldValue(i));
        }
        if (this._dataPacket.getDynamicProperties() != null) {
            props.putAll(this._dataPacket.getDynamicProperties());
        }
        return props;
    }

    @Override
    public String getUid() {
        return this._dataPacket.getUID();
    }

    @Override
    public DataSyncOperationType getDataSyncOperationType() {
        switch (this._operation) {
            case 3: {
                return DataSyncOperationType.WRITE;
            }
            case 2: {
                return DataSyncOperationType.UPDATE;
            }
            case 4: {
                return DataSyncOperationType.PARTIAL_UPDATE;
            }
        }
        return DataSyncOperationType.REMOVE;
    }

    @Override
    public Object getDataAsObject() {
        if (!this.supportsDataAsObject()) {
            throw new UnsupportedOperationException();
        }
        return this.getItem();
    }

    @Override
    public SpaceDocument getDataAsDocument() {
        if (!this.supportsDataAsDocument()) {
            throw new UnsupportedOperationException();
        }
        return this._converter.toDocument(this._dataPacket);
    }

    @Override
    public SpaceTypeDescriptor getTypeDescriptor() {
        if (!this.supportsGetTypeDescriptor()) {
            throw new UnsupportedOperationException();
        }
        return this._dataPacket.getTypeDescriptor();
    }

    @Override
    public boolean supportsGetTypeDescriptor() {
        return this._dataPacket.getTypeDescriptor() != null;
    }

    @Override
    public boolean supportsDataAsObject() {
        return this.supportsGetTypeDescriptor() && this._dataPacket.getTypeDescriptor().isConcreteType();
    }

    @Override
    public boolean supportsDataAsDocument() {
        return true;
    }
}

