/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.sync.OperationsDataBatchImpl;
import com.gigaspaces.internal.sync.TransactionDataImpl;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.sadapter.datasource.EntryPacketDataConverter;
import com.j_spaces.sadapter.datasource.IDataConverter;
import com.j_spaces.sadapter.datasource.InternalBulkItem;
import java.util.List;
import java.util.logging.Level;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

@InternalApi
public class MirrorBulkExecutor {
    private final SpaceSynchronizationEndpoint _syncEndpoint;
    private final SpaceTypeManager _typeManager;
    private final IDataConverter<IEntryPacket> _converter;

    public MirrorBulkExecutor(SpaceSynchronizationEndpoint syncEndpoint, SpaceTypeManager typeManager, Class<?> dataClass) {
        this._syncEndpoint = syncEndpoint;
        this._typeManager = typeManager;
        this._converter = new EntryPacketDataConverter(typeManager, dataClass);
    }

    public SpaceSynchronizationEndpoint getSynchronizationInterceptor() {
        return this._syncEndpoint;
    }

    public SpaceTypeManager getTypeManager() {
        return this._typeManager;
    }

    public void execute(List<BulkItem> entries, TransactionParticipantDataImpl transactionMetaData, IReplicationInBatchContext batchContext) {
        block8: {
            DataSyncOperation[] operations;
            if (entries.isEmpty()) {
                return;
            }
            for (DataSyncOperation operation : operations = entries.toArray(new DataSyncOperation[entries.size()])) {
                InternalBulkItem bulkItem = (InternalBulkItem)operation;
                bulkItem.setConverter(this._converter);
            }
            if (transactionMetaData == null) {
                OperationsDataBatchImpl batchData = new OperationsDataBatchImpl(operations, batchContext.getSourceLookupName());
                this._syncEndpoint.onOperationsBatchSynchronization(batchData);
                try {
                    this._syncEndpoint.afterOperationsBatchSynchronization(batchData);
                }
                catch (Throwable t) {
                    if (batchContext.getContextLogger().isLoggable(Level.WARNING)) {
                        batchContext.getContextLogger().log(Level.WARNING, "Synchronization endpoint interceptor afterOperationsBatchSynchronization caused an exception", t);
                    }
                    break block8;
                }
            }
            TransactionDataImpl transactionData = new TransactionDataImpl(operations, transactionMetaData, batchContext.getSourceLookupName());
            this._syncEndpoint.onTransactionSynchronization(transactionData);
            try {
                this._syncEndpoint.afterTransactionSynchronization(transactionData);
            }
            catch (Throwable t) {
                if (!batchContext.getContextLogger().isLoggable(Level.WARNING)) break block8;
                batchContext.getContextLogger().log(Level.WARNING, "Synchronization endpoint interceptor afterSynchronizingTransaction caused an exception", t);
            }
        }
    }
}

