/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.DistributedTransactionProcessingConfiguration;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MirrorConfig {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.mirror");
    private static final int DEFAULT_NUM_OF_PARTITIONS = 100;
    private static final int DEFAULT_BACKUPS_PER_PARTITION = 1;
    public static final long DIST_TX_WAIT_TIMEOUT = 60000L;
    public static final long DIST_TX_WAIT_FOR_OPERATIONS = -1L;
    private final BulkOperationGrouping _operationGrouping;
    private final String _importDirectory;
    private final String _clusterName;
    private final int _partitionsCount;
    private final int _backupsPerPartition;
    private final DistributedTransactionProcessingConfiguration _transactionProcessingConfiguration = new DistributedTransactionProcessingConfiguration(60000L, -1L);

    public MirrorConfig(SpaceConfigReader configReader) {
        String mirrorPropValue = configReader.getSpaceProperty("mirror-service.operation-grouping", "group-by-replication-bulk");
        this._operationGrouping = BulkOperationGrouping.parseOperationGroupingTag(mirrorPropValue);
        String importDirectory = configReader.getSpaceProperty("mirror-service.import-directory", null);
        if (importDirectory != null && !new File(importDirectory).isAbsolute()) {
            importDirectory = new File(SystemInfo.singleton().locations().work(), importDirectory).getAbsolutePath();
        }
        this._importDirectory = importDirectory;
        String configLogMessage = "Mirror space configuration:" + StringUtils.NEW_LINE + "\t" + "space-config.mirror-service.operation-grouping" + "=" + String.valueOf(mirrorPropValue) + "\t" + "space-config.mirror-service.import-directory" + "=" + String.valueOf(this._importDirectory);
        this._clusterName = configReader.getSpaceProperty("mirror-service.cluster.name", null);
        if (this._clusterName == null && _logger.isLoggable(Level.WARNING)) {
            _logger.warning(StringUtils.NEW_LINE + StringUtils.NEW_LINE + "**************************************************************************************" + StringUtils.NEW_LINE + "Cluster name is missing." + StringUtils.NEW_LINE + "Since version 8.0 a mirror service should be associated to a cluster by configuring the following space property:" + StringUtils.NEW_LINE + "[" + "space-config.mirror-service.cluster.name" + "] to point to the cluster name the mirror is part of." + StringUtils.NEW_LINE + "i.e if the cluster name is dataSpace, '" + "space-config.mirror-service.cluster.name" + "=dataSpace' " + StringUtils.NEW_LINE + "should be present in the mirror space properties." + StringUtils.NEW_LINE + "Without this configuration split brain consistency protection is weakened!" + StringUtils.NEW_LINE + "**************************************************************************************" + StringUtils.NEW_LINE + StringUtils.NEW_LINE);
        }
        boolean hasPartitionCount = configReader.containsSpaceProperty("mirror-service.cluster.partitions");
        this._partitionsCount = configReader.getIntSpaceProperty("mirror-service.cluster.partitions", String.valueOf(100));
        boolean hasMembersPerPartition = configReader.containsSpaceProperty("mirror-service.cluster.backups-per-partition");
        this._backupsPerPartition = configReader.getIntSpaceProperty("mirror-service.cluster.backups-per-partition", String.valueOf(1));
        if (!(hasPartitionCount && hasMembersPerPartition || !_logger.isLoggable(Level.WARNING))) {
            _logger.warning("No cluster configuration was defined for mirror - using default configuration - supports upto 100 partitions and exactly 1 backup per partition.");
        }
        String timeoutBeforePartialCommit = configReader.getSpaceProperty("mirror-service.distributed-transaction-processing.wait-timeout", null);
        String waitForOperationsBeforePartialCommit = configReader.getSpaceProperty("mirror-service.distributed-transaction-processing.wait-for-operations", null);
        String monitorPendingOperationsMemory = configReader.getSpaceProperty("mirror-service.distributed-transaction-processing.monitor-pending-operations-memory", null);
        if (timeoutBeforePartialCommit != null) {
            this._transactionProcessingConfiguration.setTimeoutBeforePartialCommit(Long.parseLong(timeoutBeforePartialCommit));
        }
        if (waitForOperationsBeforePartialCommit != null) {
            this._transactionProcessingConfiguration.setWaitForOperationsBeforePartialCommit(Integer.parseInt(waitForOperationsBeforePartialCommit));
        }
        if (monitorPendingOperationsMemory != null) {
            this._transactionProcessingConfiguration.setMonitorPendingOperationsMemory(Boolean.parseBoolean(monitorPendingOperationsMemory));
        }
        configLogMessage = configLogMessage + "\tspace-config.mirror-service.cluster.name=" + this._clusterName + "\t" + "space-config.mirror-service.cluster.partitions" + "=" + this._partitionsCount + "\t" + "space-config.mirror-service.cluster.backups-per-partition" + "=" + this._backupsPerPartition + "\t" + "mirror-service.distributed-transaction-processing.wait-timeout" + "=" + timeoutBeforePartialCommit + "\t" + "mirror-service.distributed-transaction-processing.wait-for-operations" + "=" + waitForOperationsBeforePartialCommit + "\t" + "mirror-service.distributed-transaction-processing.monitor-pending-operations-memory" + "=" + monitorPendingOperationsMemory;
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config(configLogMessage);
        }
    }

    public BulkOperationGrouping getOperationGrouping() {
        return this._operationGrouping;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public int getBackupsPerPartition() {
        return this._backupsPerPartition;
    }

    public int getPartitionsCount() {
        return this._partitionsCount;
    }

    public DistributedTransactionProcessingConfiguration getDistributedTransactionProcessingParameters() {
        return this._transactionProcessingConfiguration;
    }

    public static enum BulkOperationGrouping {
        GROUP_BY_SPACE_TRANSACTION,
        GROUP_BY_REPLICATION_BULK;


        public static BulkOperationGrouping parseOperationGroupingTag(String value) {
            if ("group-by-space-transaction".equalsIgnoreCase(value)) {
                return GROUP_BY_SPACE_TRANSACTION;
            }
            if ("group-by-replication-bulk".equalsIgnoreCase(value)) {
                return GROUP_BY_REPLICATION_BULK;
            }
            throw new IllegalArgumentException("Illegal operation-grouping tag value - '" + value + "'. Can be either " + "group-by-space-transaction" + " or " + "group-by-replication-bulk");
        }
    }
}

