/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.AbstractReplicationNodeStateListener;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.groups.BrokenReplicationTopologyException;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationSourceAlreadyAttachedException;
import com.gigaspaces.internal.sync.mirror.MirrorConfig;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MirrorNodeStateListener
extends AbstractReplicationNodeStateListener {
    private static final Logger _mirrorLogger = Logger.getLogger("com.gigaspaces.replication.mirror");
    private final String _fullSpaceName;
    private final Object _lock;
    private final boolean _stronglyTypedSourceClustername;
    private String _firstAttachedClusterName;

    public MirrorNodeStateListener(String fullSpaceName, MirrorConfig mirrorConfig) {
        this._fullSpaceName = fullSpaceName;
        this._lock = new Object();
        this._stronglyTypedSourceClustername = StringUtils.hasLength(mirrorConfig.getClusterName());
    }

    @Override
    public void onTargetChannelBacklogDropped(String groupName, String channelSourceLooString, IBacklogMemberState memberState) {
        if (_mirrorLogger.isLoggable(Level.WARNING)) {
            _mirrorLogger.warning("Mirror service [" + this._fullSpaceName + "] received channel backlog dropped message which is not allowed");
        }
    }

    @Override
    public void onSourceBrokenReplicationTopology(String groupName, String channelTargetMemberName, BrokenReplicationTopologyException error) {
        if (_mirrorLogger.isLoggable(Level.FINE)) {
            _mirrorLogger.fine("Mirror service [" + this._fullSpaceName + "] received source channel broken replication topology message which is not allowed");
        }
    }

    @Override
    public void onSourceChannelActivated(String groupName, String memberName) {
        if (_mirrorLogger.isLoggable(Level.FINE)) {
            _mirrorLogger.fine("Mirror service [" + this._fullSpaceName + "] received source channel activated message which is not allowed");
        }
    }

    @Override
    public void onNewReplicaRequest(String groupName, String memberName, boolean isSynchronizeRequest) {
        String errorMessage = "Mirror service [" + this._fullSpaceName + "] received new replica request from replication group [" + groupName + "] source member [" + memberName + "]," + StringUtils.NEW_LINE + " The operation is not supported.";
        if (_mirrorLogger.isLoggable(Level.SEVERE)) {
            _mirrorLogger.log(Level.SEVERE, errorMessage);
        }
        throw new UnsupportedOperationException(errorMessage);
    }

    @Override
    public boolean onTargetChannelOutOfSync(String groupName, String channelSourceLookupName, IncomingReplicationOutOfSyncException outOfSyncReason) {
        if (_mirrorLogger.isLoggable(Level.SEVERE)) {
            _mirrorLogger.log(Level.SEVERE, "Mirror service [" + this._fullSpaceName + "] received out of sync indication from replication group [" + groupName + "] source member [" + channelSourceLookupName + "]," + StringUtils.NEW_LINE + "it will resynchronize with the source space and may lose packets", outOfSyncReason);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTargetChannelCreationValidation(String groupName, String sourceMemberName, Object sourceUniqueId) {
        if (this._stronglyTypedSourceClustername) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._firstAttachedClusterName == null) {
                this._firstAttachedClusterName = this.extractClusterName(sourceMemberName);
                if (_mirrorLogger.isLoggable(Level.FINE)) {
                    _mirrorLogger.fine("Mirror service [" + this._fullSpaceName + "] first connected cluster is " + this._firstAttachedClusterName + ", the mirror will only accept replication from that cluster");
                }
                return;
            }
            String clusterName = this.extractClusterName(sourceMemberName);
            if (!clusterName.equals(this._firstAttachedClusterName)) {
                throw new ReplicationSourceAlreadyAttachedException("Received incompatible incoming channel creation request from replication group [" + groupName + "] and member name [" + sourceMemberName + "]. The mirror is already attached to cluster [" + this._firstAttachedClusterName + "] and it cannot create a channel to a member of cluster [" + clusterName + "]");
            }
        }
    }

    private String extractClusterName(String sourceMemberName) {
        int indexOf = sourceMemberName.indexOf("_container");
        return sourceMemberName.substring(0, indexOf);
    }
}

