/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperationsImpl;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatisticsImpl;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationTransactionalPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ITransactionalBatchExecutionCallback;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.sync.mirror.MirrorBulkDataItem;
import com.gigaspaces.internal.sync.mirror.MirrorBulkExecutor;
import com.gigaspaces.internal.sync.mirror.MirrorChangeBulkDataItem;
import com.gigaspaces.internal.sync.mirror.PartialUpdateMirrorBulkItem;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.sadapter.datasource.BulkDataPersisterContext;
import java.util.Collection;
import java.util.List;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

@InternalApi
public class MirrorReplicationInHandler
implements ITransactionalBatchExecutionCallback {
    private final MirrorBulkExecutor _bulkExecutor;
    protected final SpaceSynchronizationEndpoint _syncEndpoint;
    private final SpaceTypeManager _typeManager;
    private final MirrorStatisticsImpl _operationStatisticsHandler;

    public MirrorReplicationInHandler(MirrorBulkExecutor bulkExecutor, MirrorStatisticsImpl operationStatisticsHandler) {
        this._bulkExecutor = bulkExecutor;
        this._syncEndpoint = bulkExecutor.getSynchronizationInterceptor();
        this._typeManager = bulkExecutor.getTypeManager();
        this._operationStatisticsHandler = operationStatisticsHandler;
    }

    public void addWriteEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        BulkItem bulkItem = this.createBulkItem(entryPacket, (short)3);
        context.addPendingContext(bulkItem);
    }

    public void addUpdateEntry(IReplicationInBatchContext context, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, boolean partialUpdate) throws Exception {
        BulkItem bulkItem = null;
        bulkItem = partialUpdate ? this.createBulkItem(entryPacket, (short)4) : this.createBulkItem(entryPacket, (short)2);
        context.addPendingContext(bulkItem);
    }

    public void addRemoveEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        BulkItem bulkItem = this.createBulkItem(entryPacket, (short)1);
        context.addPendingContext(bulkItem);
    }

    public void addChangeEntry(IReplicationInBatchContext context, String typeName, String uid, Object id, int version, long timeToLive, Collection<SpaceEntryMutator> mutators) throws UnknownTypeException {
        ITypeDesc typeDesc = this._typeManager.getTypeDesc(typeName);
        if (typeDesc == null) {
            throw new UnknownTypeException("Insufficient Data In Class : " + typeName, typeName);
        }
        MirrorChangeBulkDataItem bulkItem = new MirrorChangeBulkDataItem(typeDesc, uid, id, version, timeToLive, mutators);
        context.addPendingContext(bulkItem);
    }

    public void addTransaction(IReplicationInBatchContext context, ITransactionInContext transactionContext) throws Exception {
        List packetsData = (List)((Object)transactionContext);
        for (IReplicationTransactionalPacketEntryData packetEntryData : packetsData) {
            packetEntryData.batchExecuteTransactional(context, this);
        }
    }

    private BulkItem createBulkItem(IEntryPacket entryPacket, short operation) throws UnusableEntryException, UnknownTypeException {
        this._typeManager.loadServerTypeDesc(entryPacket);
        if (operation == 4) {
            return new PartialUpdateMirrorBulkItem(entryPacket, operation);
        }
        return new MirrorBulkDataItem(entryPacket, operation);
    }

    protected void execute(IReplicationInBatchContext batchContext, TransactionParticipantDataImpl transactionParticipantData) throws SAException {
        List<BulkItem> pendingBulk = batchContext.getPendingContext();
        if (pendingBulk.isEmpty()) {
            return;
        }
        this.beforeBulkExecution(batchContext);
        try {
            BulkDataPersisterContext.setContext(new BulkDataPersisterContext(transactionParticipantData, batchContext.getSourceLookupName()));
            this._bulkExecutor.execute(pendingBulk, transactionParticipantData, batchContext);
            this.afterSuccessfulBulkExecution(batchContext);
            batchContext.pendingConsumed();
        }
        catch (RuntimeException e) {
            this.afterFailedBulkExecution(batchContext);
            throw e;
        }
        finally {
            BulkDataPersisterContext.resetContext();
        }
    }

    private void beforeBulkExecution(IReplicationInBatchContext context) {
        if (this._operationStatisticsHandler != null) {
            MirrorOperationsImpl sourceChannelStatistics = (MirrorOperationsImpl)this._operationStatisticsHandler.getSourceChannelStatistics(context.getSourceLookupName());
            List<BulkItem> bulk = context.getPendingContext();
            sourceChannelStatistics.addOperationCount(bulk);
        }
    }

    private void afterSuccessfulBulkExecution(IReplicationInBatchContext context) {
        if (this._operationStatisticsHandler != null) {
            MirrorOperationsImpl sourceChannelStatistics = (MirrorOperationsImpl)this._operationStatisticsHandler.getSourceChannelStatistics(context.getSourceLookupName());
            List<BulkItem> bulk = context.getPendingContext();
            sourceChannelStatistics.addSuccessfulOperationCount(bulk);
        }
    }

    private void afterFailedBulkExecution(IReplicationInBatchContext context) {
        if (this._operationStatisticsHandler != null) {
            MirrorOperationsImpl sourceChannelStatistics = (MirrorOperationsImpl)this._operationStatisticsHandler.getSourceChannelStatistics(context.getSourceLookupName());
            List<BulkItem> bulk = context.getPendingContext();
            sourceChannelStatistics.addFailedOperationCount(bulk);
        }
    }

    @Override
    public void removeEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        this.addRemoveEntry(context, entryPacket);
    }

    @Override
    public void removeEntryByUID(IReplicationInBatchContext context, String typeName, String uid, OperationID operationID) throws Exception {
    }

    @Override
    public void updateEntry(IReplicationInBatchContext context, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, boolean partialUpdate, short flags) throws Exception {
        this.addUpdateEntry(context, entryPacket, oldEntryPacket, partialUpdate);
    }

    @Override
    public void writeEntry(IReplicationInBatchContext context, IEntryPacket entryPacket) throws Exception {
        this.addWriteEntry(context, entryPacket);
    }

    public SpaceTypeManager getTypeManager() {
        return this._typeManager;
    }

    @Override
    public void changeEntry(IReplicationInBatchContext context, String typeName, String uid, Object id, int version, int previousVersion, long timeToLive, int routingHash, Collection<SpaceEntryMutator> spaceEntryMutators, boolean isTransient, OperationID operationID) throws UnknownTypeException {
        this.addChangeEntry(context, typeName, uid, id, version, timeToLive, spaceEntryMutators);
    }
}

