/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatisticsImpl;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.internal.sync.ConsolidationParticipantDataImpl;
import com.gigaspaces.internal.sync.mirror.MirrorBulkExecutor;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationInHandler;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.transaction.TransactionParticipantMetaData;
import java.util.List;
import java.util.logging.Level;

@InternalApi
public class MirrorReplicationInTransactionHandler
extends MirrorReplicationInHandler
implements IReplicationInTransactionHandler {
    public MirrorReplicationInTransactionHandler(MirrorBulkExecutor bulkExecutor, MirrorStatisticsImpl operationStatisticsHandler) {
        super(bulkExecutor, operationStatisticsHandler);
    }

    @Override
    public void inTransaction(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
        this.execute(batchContext, null);
        this.addTransaction(batchContext, transactionContext);
        if (batchContext.getPendingContext().isEmpty()) {
            batchContext.currentConsumed();
            return;
        }
        if (context.supportsDistributedTransactionConsolidation() && transactionContext.getMetaData() != null && transactionContext.getMetaData().isUnconsoliated() && this._syncEndpoint != null) {
            ConsolidationParticipantDataImpl consolidationParticipantData;
            block7: {
                List<DataSyncOperation> dataItems = batchContext.getPendingContext();
                consolidationParticipantData = new ConsolidationParticipantDataImpl(dataItems, (TransactionParticipantMetaData)transactionContext.getMetaData(), context);
                try {
                    this._syncEndpoint.onTransactionConsolidationFailure(consolidationParticipantData);
                }
                catch (Throwable t) {
                    if (!context.getContextLogger().isLoggable(Level.WARNING)) break block7;
                    context.getContextLogger().log(Level.WARNING, "exception caught when executing transaction consolidation interceptor on consolidation aborted [" + consolidationParticipantData + "] - ignoring exception", t);
                }
            }
            if (consolidationParticipantData.isAborted()) {
                if (context.getContextLogger().isLoggable(Level.WARNING)) {
                    context.getContextLogger().warning("aborting unconsolidated distributed transaction [" + consolidationParticipantData + "]");
                }
                batchContext.pendingConsumed();
                batchContext.setTagObject(null);
                return;
            }
            if (context.getContextLogger().isLoggable(Level.WARNING)) {
                context.getContextLogger().warning("executing unconsolidated distributed transaction [" + consolidationParticipantData + "]");
            }
        }
        this.execute(batchContext, transactionContext.getMetaData());
    }

    @Override
    public void inTransactionPrepare(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void inTransactionCommit(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void inTransactionAbort(IReplicationInContext context, ITransactionInContext transactionContext) throws Exception {
        throw new UnsupportedOperationException();
    }
}

