/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatisticsImpl;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.IReplicationInContext;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeCreatedHandler;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInDataTypeIndexAddedHandler;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.space.requests.AddTypeIndexesRequestInfo;
import com.gigaspaces.internal.sync.mirror.MirrorBulkExecutor;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationInHandler;
import com.gigaspaces.sync.AddIndexDataImpl;
import com.gigaspaces.sync.IntroduceTypeDataImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class MirrorReplicationMetadataEventHandler
extends MirrorReplicationInHandler
implements IReplicationInDataTypeCreatedHandler,
IReplicationInDataTypeIndexAddedHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication");

    public MirrorReplicationMetadataEventHandler(MirrorBulkExecutor bulkExecutor, MirrorStatisticsImpl operationStatisticsHandler) {
        super(bulkExecutor, operationStatisticsHandler);
    }

    @Override
    public void inDataTypeIntroduce(IReplicationInContext context, ITypeDesc typeDesc) throws Exception {
        block2: {
            IReplicationInBatchContext batchContext = (IReplicationInBatchContext)context;
            this.execute(batchContext, null);
            try {
                this.getTypeManager().addTypeDesc(typeDesc);
                this._syncEndpoint.onIntroduceType(new IntroduceTypeDataImpl(typeDesc));
                batchContext.currentConsumed();
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, "Conflict in type introduction.", e);
            }
        }
    }

    @Override
    public void inDataTypeAddIndex(IReplicationInContext context, AddTypeIndexesRequestInfo requestInfo) throws Exception {
        IReplicationInBatchContext batchContext;
        block2: {
            batchContext = (IReplicationInBatchContext)context;
            this.execute(batchContext, null);
            try {
                this.getTypeManager().addIndexes(requestInfo.getTypeName(), requestInfo.getIndexes());
                this._syncEndpoint.onAddIndex(new AddIndexDataImpl(requestInfo.getTypeName(), requestInfo.getIndexes()));
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.WARNING)) break block2;
                _logger.log(Level.WARNING, "Error adding new index to type [" + requestInfo.getTypeName() + "].", e);
            }
        }
        batchContext.currentConsumed();
    }
}

