/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sync.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatistics;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatisticsImpl;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInTransactionHandler;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNodeBuilder;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfig;
import com.gigaspaces.internal.cluster.node.impl.config.ReplicationNodeConfigBuilder;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReliableAsyncAdaptiveProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.DirectOnlyReplicationRouter;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.sync.mirror.MirrorBulkExecutor;
import com.gigaspaces.internal.sync.mirror.MirrorConfig;
import com.gigaspaces.internal.sync.mirror.MirrorFixFacade;
import com.gigaspaces.internal.sync.mirror.MirrorNodeStateListener;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationInAggregatedTransactionHandler;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationInBatchConsumptionHandler;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationInEntryHandler;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationInHandler;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationInTransactionHandler;
import com.gigaspaces.internal.sync.mirror.MirrorReplicationMetadataEventHandler;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;

@InternalApi
public class MirrorService {
    private static final Logger _mirrorLogger = Logger.getLogger("com.gigaspaces.replication.mirror");
    private final MirrorStatisticsImpl _mirrorStatistics = new MirrorStatisticsImpl();
    private final ReplicationNode _replicationNode;

    public MirrorService(String name, Uuid uuid, MirrorConfig mirrorConfig, SpaceSynchronizationEndpoint syncEndpoint, Class<?> dataClass, SpaceTypeManager typeManager, MetricRegistrator metricRegister) {
        this._mirrorStatistics.setMetricRegistrator(metricRegister);
        this._replicationNode = MirrorService.createReplicationNode(name, uuid, mirrorConfig, syncEndpoint, dataClass, typeManager, this._mirrorStatistics, metricRegister);
    }

    private static ReplicationNode createReplicationNode(String name, Uuid uuid, MirrorConfig mirrorConfig, SpaceSynchronizationEndpoint syncEndpoint, Class<?> dataClass, SpaceTypeManager typeManager, MirrorStatisticsImpl mirrorStatistics, MetricRegistrator metricRegister) {
        MirrorReplicationInHandler txnHandler;
        ReplicationNodeBuilder nodeBuilder = new ReplicationNodeBuilder();
        nodeBuilder.setReplicationRouterBuilder(new DirectOnlyReplicationRouter.Builder(name, uuid));
        MirrorFixFacade fixFacade = new MirrorFixFacade(syncEndpoint, typeManager);
        ReplicationPacketDataConsumer dataConsumer = new ReplicationPacketDataConsumer(typeManager, fixFacade, null);
        nodeBuilder.setReplicationProcessLogBuilder(new ReliableAsyncAdaptiveProcessLogBuilder(dataConsumer, mirrorConfig.getDistributedTransactionProcessingParameters()));
        ReplicationNodeConfig replicationNodeConfig = ReplicationNodeConfigBuilder.getInstance().createMirrorConfig(mirrorConfig, nodeBuilder);
        ReplicationNode replicationNode = new ReplicationNode(replicationNodeConfig, nodeBuilder, name, metricRegister);
        MirrorBulkExecutor bulkExecutor = new MirrorBulkExecutor(syncEndpoint, typeManager, dataClass);
        replicationNode.setInEntryHandler(new MirrorReplicationInEntryHandler(bulkExecutor, mirrorStatistics));
        MirrorReplicationMetadataEventHandler metadataHandler = new MirrorReplicationMetadataEventHandler(bulkExecutor, mirrorStatistics);
        replicationNode.setInDataTypeCreatedHandler(metadataHandler);
        replicationNode.setInDataTypeIndexAddedHandler(metadataHandler);
        replicationNode.setInBatchConsumptionHandler(new MirrorReplicationInBatchConsumptionHandler(bulkExecutor, mirrorStatistics));
        MirrorConfig.BulkOperationGrouping transactionGrouping = mirrorConfig.getOperationGrouping();
        switch (transactionGrouping) {
            case GROUP_BY_REPLICATION_BULK: {
                txnHandler = new MirrorReplicationInAggregatedTransactionHandler(bulkExecutor, mirrorStatistics);
                break;
            }
            case GROUP_BY_SPACE_TRANSACTION: {
                txnHandler = new MirrorReplicationInTransactionHandler(bulkExecutor, mirrorStatistics);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported transaction grouping " + (Object)((Object)transactionGrouping));
            }
        }
        replicationNode.setInTransactionHandler((IReplicationInTransactionHandler)((Object)txnHandler));
        if (_mirrorLogger.isLoggable(Level.FINE)) {
            _mirrorLogger.fine("No source cluster provided for mirror, mirror will attach to the first encountered cluster");
        }
        replicationNode.getAdmin().setNodeStateListener(new MirrorNodeStateListener(name, mirrorConfig));
        replicationNode.getAdmin().getRouterAdmin().enableIncomingCommunication();
        return replicationNode;
    }

    public ReplicationNode getReplicationNode() {
        return this._replicationNode;
    }

    public MirrorStatistics getMirrorStatistics() {
        return this._mirrorStatistics;
    }
}

