/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.serialization.AbstractExternalizable;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.core.OperationID;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

public abstract class AbstractEntryPacket
extends AbstractExternalizable
implements IEntryPacket,
Textualizable {
    private static final long serialVersionUID = 1L;
    protected ITypeDesc _typeDesc;
    protected int _typeDescChecksum;
    private OperationID _operationID;
    private boolean _serializeTypeDesc;
    protected EntryType _entryType;
    protected transient byte _entryTypeCode;
    private int _previousVersion;
    private static final short FLAG_OPERATION_ID = 1;
    private static final short FLAG_TYPE_DESC = 2;
    private static final short FLAG_TYPE_DESC_CHECKSUM = 4;
    private static final short FLAG_REQUEST_TYPE = 8;
    private static final short FLAG_PREVIOUS_VERSION = 16;

    protected AbstractEntryPacket() {
    }

    protected AbstractEntryPacket(ITypeDesc typeDesc, EntryType entryType) {
        this._typeDesc = typeDesc;
        this._typeDescChecksum = typeDesc != null ? typeDesc.getChecksum() : 0;
        this._entryType = entryType;
    }

    @Override
    public IEntryPacket clone() {
        try {
            return (AbstractEntryPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("typeName", this.getTypeName());
        textualizer.append("uid", this.getUID());
        textualizer.append("version", this.getVersion());
        textualizer.append("operationId", this.getOperationID());
    }

    public int hashCode() {
        return this.getUID() != null ? this.getUID().hashCode() : 10;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IEntryPacket)) {
            return false;
        }
        IEntryPacket other = (IEntryPacket)obj;
        if (this.getUID() == other.getUID()) {
            return true;
        }
        if (this.getUID() == null || other.getUID() == null) {
            return false;
        }
        return this.getUID().equals(other.getUID());
    }

    @Override
    public EntryType getEntryType() {
        return this._entryType;
    }

    @Override
    public String getExternalEntryImplClassName() {
        return null;
    }

    @Override
    public OperationID getOperationID() {
        return this._operationID;
    }

    @Override
    public void setOperationID(OperationID operationID) {
        this._operationID = operationID;
    }

    @Override
    public ITypeDesc getTypeDescriptor() {
        return this._typeDesc;
    }

    @Override
    public void setTypeDesc(ITypeDesc typeDesc, boolean serializeTypeDesc) {
        this._typeDesc = typeDesc;
        this._typeDescChecksum = this._typeDesc != null ? this._typeDesc.getChecksum() : 0;
        this._serializeTypeDesc = serializeTypeDesc;
    }

    @Override
    public int getTypeDescChecksum() {
        return this._typeDescChecksum;
    }

    @Override
    public boolean supportsTypeDescChecksum() {
        return true;
    }

    @Override
    public boolean isSerializeTypeDesc() {
        return this._serializeTypeDesc;
    }

    @Override
    public void setSerializeTypeDesc(boolean serializeTypeDesc) {
        this._serializeTypeDesc = serializeTypeDesc;
    }

    @Override
    public String getCodebase() {
        return this._typeDesc != null ? this._typeDesc.getCodeBase() : null;
    }

    @Override
    public Object getPropertyValue(String name) {
        ITypeDesc typeDesc = this.getTypeDescriptor();
        int pos = typeDesc.getFixedPropertyPosition(name);
        if (pos != -1) {
            return this.getFieldValue(pos);
        }
        if (!typeDesc.supportsDynamicProperties()) {
            throw new IllegalArgumentException("Failed to get value of property '" + name + "' in type '" + typeDesc.getTypeName() + "' - it does not exist and the type does not support dynamic properties.");
        }
        Map<String, Object> dynamicProperties = this.getDynamicProperties();
        return dynamicProperties != null ? dynamicProperties.get(name) : null;
    }

    @Override
    public void setPropertyValue(String name, Object value) {
        ITypeDesc typeDesc = this.getTypeDescriptor();
        int pos = typeDesc.getFixedPropertyPosition(name);
        if (pos != -1) {
            this.setFieldValue(pos, value);
        } else {
            if (this.getDynamicProperties() == null) {
                throw new IllegalArgumentException("Failed to set value of property '" + name + "' in type '" + typeDesc.getTypeName() + "' - it does not exist and the type does not support dynamic properties.");
            }
            this.getDynamicProperties().put(name, value);
        }
    }

    @Override
    public Object getID() {
        ITypeDesc typeDesc = this.getTypeDescriptor();
        int identifierPropertyId = typeDesc.getIdentifierPropertyId();
        Object value = null;
        if (identifierPropertyId != -1) {
            value = this.getFieldValue(identifierPropertyId);
        }
        if (value == null) {
            value = this.getUID();
        }
        return value;
    }

    @Override
    public int getPreviousVersion() {
        return this._previousVersion;
    }

    @Override
    public void setPreviousVersion(int previousVersion) {
        this._previousVersion = previousVersion;
    }

    @Override
    public boolean hasPreviousVersion() {
        return this._previousVersion != 0;
    }

    @Override
    public Object getRoutingFieldValue() {
        if (this._typeDesc.isAutoGenerateRouting()) {
            return SpaceUidFactory.extractPartitionId(this.getUID());
        }
        int routingPropertyId = this._typeDesc.getRoutingPropertyId();
        return routingPropertyId == -1 ? null : this.getFieldValue(routingPropertyId);
    }

    @Override
    public Object toObject(QueryResultTypeInternal resultType) {
        return this.toObject(resultType, StorageTypeDeserialization.EAGER);
    }

    @Override
    public Object toObject(QueryResultTypeInternal resultType, StorageTypeDeserialization storageTypeDeserialization) {
        if (resultType.isPbs()) {
            return this;
        }
        EntryType entryType = resultType.getEntryType();
        if (entryType == null && this.getTypeDescriptor() != null) {
            entryType = this.getTypeDescriptor().getObjectType();
        }
        return this.toObject(entryType, storageTypeDeserialization);
    }

    @Override
    public boolean hasFixedPropertiesArray() {
        return false;
    }

    @Override
    public Object toObject(EntryType entryType) {
        return this.toObject(entryType, StorageTypeDeserialization.EAGER);
    }

    @Override
    public Object toObject(EntryType entryType, StorageTypeDeserialization storageTypeDeserialization) {
        ITypeIntrospector introspector = this._typeDesc.getIntrospector(entryType);
        return introspector.toObject(this, storageTypeDeserialization);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        this.writeExternal(out, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this.readExternal(in, LRMIInvocationContext.getEndpointLogicalVersion());
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        this.serialize(out);
    }

    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    private final void serialize(ObjectOutput out) throws IOException {
        short flags = this.buildFlags();
        out.writeShort(flags);
        if (this._operationID != null) {
            IOUtils.writeObject(out, this._operationID);
        }
        if (this._serializeTypeDesc && this._typeDesc != null) {
            IOUtils.writeObject(out, this._typeDesc);
        }
        if (this._typeDescChecksum != 0) {
            out.writeInt(this._typeDescChecksum);
        }
        if (this._entryType != null) {
            out.writeByte(this._entryType.getTypeCode());
        }
        if (this._previousVersion != 0) {
            out.writeInt(this._previousVersion);
        }
    }

    private void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        boolean bl = this._serializeTypeDesc = (flags & 2) != 0;
        if ((flags & 1) != 0) {
            this._operationID = (OperationID)IOUtils.readObject(in);
        }
        if (this._serializeTypeDesc) {
            this._typeDesc = (ITypeDesc)IOUtils.readObject(in);
        }
        if ((flags & 4) != 0) {
            this._typeDescChecksum = in.readInt();
        }
        if ((flags & 8) != 0) {
            this._entryTypeCode = in.readByte();
            this._entryType = EntryType.fromByte(this._entryTypeCode);
        }
        if ((flags & 0x10) != 0) {
            this._previousVersion = in.readInt();
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._operationID != null) {
            flags = (short)(flags | 1);
        }
        if (this._serializeTypeDesc && this._typeDesc != null) {
            flags = (short)(flags | 2);
        }
        if (this._entryType != null) {
            flags = (short)(flags | 8);
        }
        if (this._typeDescChecksum != 0) {
            flags = (short)(flags | 4);
        }
        if (this._previousVersion != 0) {
            flags = (short)(flags | 0x10);
        }
        return flags;
    }

    protected void validateStorageType() {
        ITypeDesc typeDesc = this._typeDesc;
        if (typeDesc.isAllPropertiesObjectStorageType()) {
            return;
        }
        PropertyInfo[] properties = typeDesc.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            Object fieldValue;
            PropertyInfo property = properties[i];
            StorageType storageType = property.getStorageType();
            if (storageType == StorageType.OBJECT || (fieldValue = this.getFieldValue(i)) == null) continue;
            throw new IllegalArgumentException("[" + property.getName() + "] Cannot match property that have storage type other than " + (Object)((Object)StorageType.OBJECT) + " storage type (current storage type is " + (Object)((Object)storageType) + ").");
        }
    }

    @Override
    public boolean isExternalizableEntryPacket() {
        return false;
    }
}

