/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.ServerTypeDesc;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.PathsProjectionHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractProjectionTemplate
implements Externalizable {
    private static final long serialVersionUID = 2034439490260048928L;
    private volatile transient PathsProjectionHandler _pathsHandler;
    private transient Boolean _isAllIndexesProjections;

    public abstract int[] getFixedPropertiesIndexes();

    public abstract String[] getDynamicProperties();

    public abstract String[] getFixedPaths();

    public abstract String[] getDynamicPaths();

    public void filterOutNonProjectionProperties(IEntryPacket entryPacket) {
        if (entryPacket == null) {
            return;
        }
        PathsProjectionHandler pathsHandler = null;
        int[] fixedPropertiesIndexes = this.getFixedPropertiesIndexes();
        if (entryPacket.getFieldValues() != null) {
            int numOfFixedProperties = entryPacket.getTypeDescriptor().getNumOfFixedProperties();
            Object[] projectedValues = new Object[numOfFixedProperties];
            if (fixedPropertiesIndexes != null) {
                int[] nArray = fixedPropertiesIndexes;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int index = nArray[i];
                    projectedValues[index] = entryPacket.getFieldValue(index);
                }
            }
            if (this.getFixedPaths() != null) {
                pathsHandler = this.getPathsHandler(entryPacket.getTypeDescriptor());
                pathsHandler.applyFixedPathsProjections(entryPacket, projectedValues);
            }
            entryPacket.setFieldsValues(projectedValues);
        }
        if (entryPacket.getDynamicProperties() != null) {
            DocumentProperties projectedDynamicProperties = null;
            if (this.getDynamicProperties() != null) {
                projectedDynamicProperties = new DocumentProperties(this.getDynamicProperties().length);
                for (String dynamicProperty : this.getDynamicProperties()) {
                    projectedDynamicProperties.put(dynamicProperty, entryPacket.getDynamicProperties().get(dynamicProperty));
                }
            }
            if (this.getDynamicPaths() != null) {
                if (projectedDynamicProperties == null) {
                    projectedDynamicProperties = new DocumentProperties(this.getDynamicPaths().length);
                }
                if (pathsHandler == null) {
                    pathsHandler = this.getPathsHandler(entryPacket.getTypeDescriptor());
                }
                pathsHandler.applyDynamicPathsProjections(entryPacket, projectedDynamicProperties);
            }
            entryPacket.setDynamicProperties(projectedDynamicProperties);
        }
    }

    public void filterOutNonProjectionProperties(IEntryData entryData) {
        if (entryData == null) {
            return;
        }
        PathsProjectionHandler pathsHandler = null;
        int[] fixedPropertiesIndexes = this.getFixedPropertiesIndexes();
        if (entryData.getFixedPropertiesValues() != null) {
            int numberOfFixedProperties = entryData.getNumOfFixedProperties();
            Object[] projectedValues = new Object[numberOfFixedProperties];
            if (fixedPropertiesIndexes != null) {
                for (int index : fixedPropertiesIndexes) {
                    projectedValues[index] = entryData.getFixedPropertiesValues()[index];
                }
            }
            if (this.getFixedPaths() != null) {
                pathsHandler = this.getPathsHandler(entryData.getEntryTypeDesc().getTypeDesc());
                pathsHandler.applyFixedPathsProjections(entryData, projectedValues);
            }
            entryData.setFixedPropertyValues(projectedValues);
        }
    }

    public boolean isAllIndexesProjections(IServerTypeDesc serverTypeDesc, ITemplateHolder templateHolder, String uid) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAllIndexesProjections(IServerTypeDesc serverTypeDesc, ITemplateHolder templateHolder) {
        if (this._isAllIndexesProjections != null) {
            return this._isAllIndexesProjections;
        }
        if (templateHolder.isNotifyTemplate()) {
            AbstractProjectionTemplate abstractProjectionTemplate = this;
            synchronized (abstractProjectionTemplate) {
                if (this._isAllIndexesProjections != null) {
                    return this._isAllIndexesProjections;
                }
                this._isAllIndexesProjections = this.isAllIndexesProjections_impl(serverTypeDesc);
                return this._isAllIndexesProjections;
            }
        }
        this._isAllIndexesProjections = this.isAllIndexesProjections_impl(serverTypeDesc);
        return this._isAllIndexesProjections;
    }

    public boolean isMultiUidsProjection() {
        return false;
    }

    private boolean isAllIndexesProjections_impl(IServerTypeDesc serverTypeDesc) {
        if (serverTypeDesc.isMaybeOutdated()) {
            serverTypeDesc = ServerTypeDesc.getByServerTypeDescCode(serverTypeDesc.getServerTypeDescCode());
        }
        if (this.getDynamicProperties() != null) {
            for (String prop : this.getDynamicProperties()) {
                if (serverTypeDesc.getTypeDesc().getIndexes().containsKey(prop)) continue;
                return false;
            }
        }
        if (this.getDynamicPaths() != null) {
            for (String path : this.getDynamicPaths()) {
                if (serverTypeDesc.getTypeDesc().getIndexes().containsKey(path)) continue;
                return false;
            }
        }
        if (this.getFixedPropertiesIndexes() != null) {
            for (int pos : this.getFixedPropertiesIndexes()) {
                if (serverTypeDesc.getTypeDesc().getIndexedPropertyID(pos) != -1) continue;
                return false;
            }
        }
        if (this.getFixedPaths() != null) {
            for (String path : this.getFixedPaths()) {
                if (serverTypeDesc.getTypeDesc().getIndexes().containsKey(path)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathsProjectionHandler getPathsHandler(ITypeDesc typeDesc) {
        String[] lockObject;
        if (this.getFixedPaths() == null && this.getDynamicPaths() == null) {
            return null;
        }
        PathsProjectionHandler pathsHandler = this._pathsHandler;
        if (pathsHandler != null) {
            return pathsHandler;
        }
        String[] stringArray = lockObject = this.getFixedPaths() != null ? this.getFixedPaths() : this.getDynamicPaths();
        synchronized (lockObject) {
            if (this._pathsHandler != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this._pathsHandler;
            }
            this._pathsHandler = new PathsProjectionHandler(this.getFixedPaths(), this.getDynamicPaths(), typeDesc);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this._pathsHandler;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

