/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.transport.AbstractEntryPacket;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.client.ExternalEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import net.jini.space.InternalSpaceException;

public abstract class AbstractQueryPacket
extends AbstractEntryPacket
implements ITemplatePacket {
    private static final long serialVersionUID = 1L;
    private QueryResultTypeInternal _queryResultType;

    protected AbstractQueryPacket() {
    }

    protected AbstractQueryPacket(ITypeDesc typeDesc, QueryResultTypeInternal resultType) {
        super(typeDesc, resultType.getEntryType());
        this._queryResultType = resultType;
    }

    @Override
    public TransportPacketType getPacketType() {
        throw new UnsupportedOperationException("This method is not supported for query packets.");
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return null;
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
    }

    @Override
    public QueryResultTypeInternal getQueryResultType() {
        return this._queryResultType;
    }

    public void setQueryResultType(QueryResultTypeInternal queryResultType) {
        this._queryResultType = queryResultType;
    }

    @Override
    public boolean supportExtendedMatching() {
        return false;
    }

    @Override
    public short[] getExtendedMatchCodes() {
        return null;
    }

    @Override
    public Object[] getRangeValues() {
        return null;
    }

    @Override
    public boolean[] getRangeValuesInclusion() {
        return null;
    }

    @Override
    public String getTypeName() {
        return this._typeDesc != null ? this._typeDesc.getTypeName() : null;
    }

    @Override
    public String[] getMultipleUIDs() {
        return null;
    }

    @Override
    public void setMultipleUIDs(String[] uids) {
    }

    @Override
    public Object[] getFieldValues() {
        return null;
    }

    @Override
    public void setFieldsValues(Object[] values) {
    }

    @Override
    public Object getFieldValue(int index) {
        Object[] values = this.getFieldValues();
        if (values == null) {
            return null;
        }
        return values[index];
    }

    @Override
    public void setFieldValue(int index, Object value) {
        Object[] values = this.getFieldValues();
        if (values == null) {
            return;
        }
        values[index] = value;
    }

    @Override
    public Object getID() {
        int index = this.getIdentifierFieldIndex();
        return index >= 0 ? this.getFieldValue(index) : null;
    }

    protected int getIdentifierFieldIndex() {
        return this._typeDesc != null ? this._typeDesc.getIdentifierPropertyId() : -1;
    }

    @Override
    public boolean isFifo() {
        return false;
    }

    @Override
    public boolean isNoWriteLease() {
        return false;
    }

    @Override
    public boolean isReturnOnlyUids() {
        return false;
    }

    @Override
    public void setReturnOnlyUIDs(boolean returnOnlyUIDs) {
    }

    @Override
    public boolean isTransient() {
        ITypeDesc typeDesc = this.getTypeDescriptor();
        return typeDesc.getIntrospector(this.getEntryType()).isTransient(null);
    }

    @Override
    public long getTTL() {
        return 0L;
    }

    @Override
    public void setTTL(long ttl) {
    }

    @Override
    public String getUID() {
        return null;
    }

    @Override
    public void setUID(String uid) {
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void setVersion(int version) {
    }

    @Override
    public ICustomQuery getCustomQuery() {
        return null;
    }

    @Override
    public void setCustomQuery(ICustomQuery customQuery) {
    }

    @Override
    public AbstractProjectionTemplate getProjectionTemplate() {
        return null;
    }

    @Override
    public void setProjectionTemplate(AbstractProjectionTemplate projectionTemplate) {
    }

    @Override
    public AbstractQueryPacket clone() {
        return (AbstractQueryPacket)super.clone();
    }

    @Override
    public Object toObject(EntryType entryType, StorageTypeDeserialization storageTypeDeserialization) {
        if (!this.isReturnOnlyUids()) {
            throw new InternalSpaceException("toObject() is not supported in query packets when isReturnOnlyUids() is false.");
        }
        if (this.getMultipleUIDs() != null) {
            return new ExternalEntry(this.getMultipleUIDs());
        }
        return new ExternalEntry(this.getUID());
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serialize(out);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserialize(in);
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serialize(out);
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserialize(in);
    }

    private void serialize(ObjectOutput out) throws IOException {
        out.writeByte(this._queryResultType.getCode());
    }

    private void deserialize(ObjectInput in) throws IOException {
        this._queryResultType = QueryResultTypeInternal.fromCode(in.readByte());
    }

    @Override
    public void validate() {
    }

    @Override
    public boolean isIdQuery() {
        return false;
    }

    @Override
    public boolean isIdsQuery() {
        return false;
    }

    @Override
    public boolean isTemplateQuery() {
        return false;
    }

    @Override
    public boolean isAllIndexValuesSqlQuery() {
        return false;
    }
}

