/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOArrayException;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.transport.AbstractEntryPacket;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.EntrySerializationException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

@InternalApi
public class EntryPacket
extends AbstractEntryPacket {
    private static final long serialVersionUID = 1L;
    protected String _typeName;
    private Object[] _fixedProperties;
    private Map<String, Object> _dynamicProperties;
    private String _uid;
    private int _version;
    private long _timeToLive;
    private boolean _transient;
    private ICustomQuery _customQuery;
    private String[] _multipleUIDs;
    protected boolean _returnOnlyUIDs;
    private boolean _noWriteLease;
    private boolean _fifo;
    private static final short FLAG_CLASSNAME = 1;
    private static final short FLAG_UID = 2;
    private static final short FLAG_VERSION = 4;
    private static final short FLAG_TIME_TO_LIVE = 8;
    private static final short FLAG_MULTIPLE_UIDS = 16;
    private static final short FLAG_FIELDS_VALUES = 32;
    private static final short FLAG_FIFO = 64;
    private static final short FLAG_TRANSIENT = 128;
    private static final short FLAG_NO_WRITE_LEASE = 256;
    private static final short FLAG_RETURN_ONLY_UIDS = 512;
    private static final short FLAG_CUSTOM_QUERY = 1024;
    private static final short FLAG_DYNAMIC_PROPERTIES = 2048;

    public EntryPacket() {
    }

    public EntryPacket(ITypeDesc typeDesc, EntryType entryType, Object[] fixedProperties, Map<String, Object> dynamicProperties, String uid, int version, long timeToLive, boolean isTransient) {
        super(typeDesc, entryType);
        this._typeName = typeDesc.getTypeName();
        this._fixedProperties = fixedProperties;
        this._dynamicProperties = dynamicProperties;
        this._uid = uid;
        this._version = version;
        this._timeToLive = timeToLive;
        this._transient = isTransient;
        this._noWriteLease = false;
        this._fifo = false;
    }

    protected EntryPacket(ITypeDesc typeDesc, Object[] values) {
        super(typeDesc, typeDesc.getObjectType());
        this._typeName = typeDesc.getTypeName();
        this._fixedProperties = values;
    }

    @Override
    public IEntryPacket clone() {
        IEntryPacket packet = super.clone();
        if (this._fixedProperties != null) {
            packet.setFieldsValues((Object[])this._fixedProperties.clone());
        }
        return packet;
    }

    @Override
    public TransportPacketType getPacketType() {
        return TransportPacketType.ENTRY_PACKET;
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public String getUID() {
        return this._uid;
    }

    @Override
    public void setUID(String uid) {
        this._uid = uid;
    }

    @Override
    public String[] getMultipleUIDs() {
        return this._multipleUIDs;
    }

    @Override
    public void setMultipleUIDs(String[] multipleUIDs) {
        this._multipleUIDs = multipleUIDs;
    }

    public boolean isReturnOnlyUids() {
        return this._returnOnlyUIDs;
    }

    public void setReturnOnlyUIDs(boolean returnOnlyUIDs) {
        this._returnOnlyUIDs = returnOnlyUIDs;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._dynamicProperties;
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        this._dynamicProperties = dynamicProperties;
    }

    @Override
    public Object[] getFieldValues() {
        return this._fixedProperties;
    }

    @Override
    public void setFieldsValues(Object[] values) {
        this._fixedProperties = values;
    }

    @Override
    public Object getFieldValue(int index) {
        try {
            return this._fixedProperties[index];
        }
        catch (Exception e) {
            throw new IllegalStateException("The field values array was not properly set", e);
        }
    }

    @Override
    public void setFieldValue(int index, Object value) {
        try {
            this._fixedProperties[index] = value;
        }
        catch (Exception e) {
            throw new IllegalStateException("The field values array was not properly set", e);
        }
    }

    @Override
    public boolean isTransient() {
        return this._transient;
    }

    @Override
    public boolean isFifo() {
        return this._fifo;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public long getTTL() {
        return this._timeToLive;
    }

    @Override
    public void setTTL(long ttl) {
        this._timeToLive = ttl;
    }

    @Override
    public boolean isNoWriteLease() {
        return this._noWriteLease;
    }

    @Override
    public ICustomQuery getCustomQuery() {
        return this._customQuery;
    }

    @Override
    public void setCustomQuery(ICustomQuery customQuery) {
        this._customQuery = customQuery;
    }

    private short buildFlags() {
        short flags = 0;
        if (this._typeName != null) {
            flags = (short)(flags | 1);
        }
        if (this._uid != null) {
            flags = (short)(flags | 2);
        }
        if (this._version != 0) {
            flags = (short)(flags | 4);
        }
        if (this._timeToLive != 0L) {
            flags = (short)(flags | 8);
        }
        if (this._multipleUIDs != null) {
            flags = (short)(flags | 0x10);
        }
        if (this._fixedProperties != null) {
            flags = (short)(flags | 0x20);
        }
        if (this._fifo) {
            flags = (short)(flags | 0x40);
        }
        if (this._transient) {
            flags = (short)(flags | 0x80);
        }
        if (this._noWriteLease) {
            flags = (short)(flags | 0x100);
        }
        if (this._returnOnlyUIDs) {
            flags = (short)(flags | 0x200);
        }
        if (this._customQuery != null) {
            flags = (short)(flags | 0x400);
        }
        if (this._dynamicProperties != null) {
            flags = (short)(flags | 0x800);
        }
        return flags;
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serializePacket(out, PlatformLogicalVersion.getLogicalVersion());
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserializePacket(in, PlatformLogicalVersion.getLogicalVersion());
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serializePacket(out, version);
    }

    private final void serializePacket(ObjectOutput out, PlatformLogicalVersion version) {
        try {
            out.writeShort(this.buildFlags());
            if (this._typeName != null) {
                IOUtils.writeRepetitiveString(out, this._typeName);
            }
            if (this._uid != null) {
                IOUtils.writeString(out, this._uid);
            }
            if (this._version != 0) {
                out.writeInt(this._version);
            }
            if (this._timeToLive != 0L) {
                out.writeLong(this._timeToLive);
            }
            if (this._multipleUIDs != null) {
                IOUtils.writeStringArray(out, this._multipleUIDs);
            }
            if (this._fixedProperties != null) {
                try {
                    IOUtils.writeObjectArrayCompressed(out, this._fixedProperties);
                }
                catch (IOArrayException e) {
                    throw this.createPropertySerializationException(e, true);
                }
            }
            if (this._dynamicProperties != null) {
                IOUtils.writeObject(out, this._dynamicProperties);
            }
            if (this._customQuery != null) {
                IOUtils.writeObject(out, this._customQuery);
            }
        }
        catch (EntrySerializationException e) {
            throw e;
        }
        catch (Exception e) {
            String className = this._typeName == null ? "." : this._typeName;
            throw new EntrySerializationException("Failed to serialize Entry " + className, e);
        }
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserializePacket(in, version);
    }

    private final void deserializePacket(ObjectInput in, PlatformLogicalVersion version) {
        try {
            short flags = in.readShort();
            this._fifo = (flags & 0x40) != 0;
            this._transient = (flags & 0x80) != 0;
            this._noWriteLease = (flags & 0x100) != 0;
            boolean bl = this._returnOnlyUIDs = (flags & 0x200) != 0;
            if ((flags & 1) != 0) {
                this._typeName = IOUtils.readRepetitiveString(in);
            }
            if ((flags & 2) != 0) {
                this._uid = IOUtils.readString(in);
            }
            if ((flags & 4) != 0) {
                this._version = in.readInt();
            }
            if ((flags & 8) != 0) {
                this._timeToLive = in.readLong();
            }
            if ((flags & 0x10) != 0) {
                this._multipleUIDs = IOUtils.readStringArray(in);
            }
            if ((flags & 0x20) != 0) {
                try {
                    this._fixedProperties = IOUtils.readObjectArrayCompressed(in);
                }
                catch (IOArrayException e) {
                    throw this.createPropertySerializationException(e, false);
                }
            }
            if ((flags & 0x800) != 0) {
                this._dynamicProperties = (Map)IOUtils.readObject(in);
            }
            if ((flags & 0x400) != 0) {
                this._customQuery = (ICustomQuery)IOUtils.readObject(in);
            }
        }
        catch (EntrySerializationException e) {
            throw e;
        }
        catch (Exception e) {
            String className = this._typeName != null ? this._typeName : ".";
            throw new EntrySerializationException("Failed to deserialize Entry " + className, e);
        }
    }

    private EntrySerializationException createPropertySerializationException(IOArrayException e, boolean isSerialize) {
        int index = e.getIndex();
        String message = "Failed to " + (isSerialize ? "serialize" : "deserialize") + " property #" + index;
        ITypeDesc typeDesc = this.getTypeDescriptor();
        if (typeDesc != null) {
            int numOfProperties = typeDesc.getNumOfFixedProperties();
            if (index < 0 || index >= numOfProperties) {
                message = message + " (index out of bound: number of properties=" + numOfProperties + ")";
            } else {
                PropertyInfo property = typeDesc.getFixedProperty(index);
                message = message + " (Name=[" + property.getName() + "], Type=[" + property.getTypeName() + "])";
            }
        }
        message = message + " in entry of type [" + this.getTypeName() + "].";
        if (isSerialize) {
            message = message + " Value=[" + String.valueOf(this.getFieldValue(index)) + "]";
        }
        return new EntrySerializationException(message, e.getCause());
    }

    @Override
    public boolean hasFixedPropertiesArray() {
        return true;
    }
}

