/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.document.DocumentObjectConverterInternal;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ExternalEntryIntrospector;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.UserTypeEntryData;
import com.gigaspaces.internal.transport.EntryPacket;
import com.gigaspaces.internal.transport.ExternalizableEntryPacket;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.PbsEntryPacket;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.j_spaces.core.ExternalEntryPacket;
import com.j_spaces.core.LocalCacheResponseEntryPacket;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.client.Modifiers;
import java.io.Externalizable;
import java.util.Map;

@InternalApi
public class EntryPacketFactory {
    public static <T> IEntryPacket createFromObject(T entry, ITypeDesc typeDesc, EntryType entryType, boolean ignoreAutoGenerateUid) {
        if (entryType.isConcrete() && typeDesc.isExternalizable()) {
            return new ExternalizableEntryPacket(typeDesc, entryType, (Externalizable)entry);
        }
        ITypeIntrospector introspector = typeDesc.getIntrospector(entryType);
        Object[] fixedProperties = introspector.getSerializedValues(entry);
        Map<String, Object> dynamicProperties = introspector.getDynamicProperties(entry);
        if (!typeDesc.supportsDynamicProperties() && dynamicProperties != null && !dynamicProperties.isEmpty()) {
            String propertyName = (String)dynamicProperties.keySet().toArray()[0];
            String message = "Cannot access dynamic property '" + propertyName + "' in type '" + typeDesc.getTypeName() + "' - this type does not support dynamic properties.";
            if (typeDesc.getTypeName().equals(Object.class.getName())) {
                message = message + " If you're using SpaceDocument make sure the type name was properly set.";
            }
            throw new SpaceMetadataException(message);
        }
        String uid = introspector.getUID(entry, false, ignoreAutoGenerateUid);
        if (uid == null && entryType == EntryType.EXTERNAL_ENTRY) {
            uid = ExternalEntryIntrospector.getUid(typeDesc, fixedProperties);
        }
        return new EntryPacket(typeDesc, entryType, fixedProperties, dynamicProperties, uid, introspector.getVersion(entry), introspector.getTimeToLive(entry), introspector.isTransient(entry));
    }

    public static IEntryPacket createFullPacket(IEntryData entryData, OperationID operationID, String uid, boolean isTransient, QueryResultTypeInternal queryResultType) {
        long timeToLive = entryData.getTimeToLive(true);
        IEntryPacket entryPacket = EntryPacketFactory.createInternal(null, isTransient, entryData, entryData.getFixedPropertiesValues(), uid, timeToLive, queryResultType, false);
        entryPacket.setOperationID(operationID);
        return entryPacket;
    }

    public static IEntryPacket createFullPacketForReplication(IEntryHolder entryHolder, OperationID operationID) {
        IEntryData entryData = entryHolder.getEntryData();
        long timeToLive = entryData.getTimeToLive(true);
        IEntryPacket entryPacket = EntryPacketFactory.create(null, entryHolder.isTransient(), entryData, entryData.getFixedPropertiesValues(), entryHolder.getUID(), timeToLive, true);
        entryPacket.setOperationID(operationID);
        return entryPacket;
    }

    public static IEntryPacket createPartialUpdatePacketForReplication(IEntryHolder entryHolder, OperationID operationID, boolean[] partialUpdatedValuesIndicators) {
        IEntryData entryData = entryHolder.getEntryData();
        long timeToLive = entryData.getTimeToLive(true);
        Object[] fixedProperties = EntryPacketFactory.getPartialUpdateFieldValues(entryData, partialUpdatedValuesIndicators);
        IEntryPacket entryPacket = EntryPacketFactory.create(null, entryHolder.isTransient(), entryData, fixedProperties, entryHolder.getUID(), timeToLive, true);
        entryPacket.setOperationID(operationID);
        return entryPacket;
    }

    public static IEntryPacket createFullPacketForReplication(IEntryHolder entryHolder, ITemplateHolder template, String uid, long timeToLive) {
        IEntryData entryData = entryHolder.getEntryData();
        return EntryPacketFactory.create(template, entryHolder.isTransient(), entryData, entryData.getFixedPropertiesValues(), uid, timeToLive, true);
    }

    public static IEntryPacket createFullPacket(IEntryHolder entryHolder, ITemplateHolder template, String uid, long timeToLive, IEntryData entryData, OperationID operationId) {
        IEntryPacket packet = EntryPacketFactory.create(template, entryHolder.isTransient(), entryData, entryData.getFixedPropertiesValues(), uid, timeToLive, false);
        packet.setOperationID(operationId);
        return packet;
    }

    public static IEntryPacket createFullPacket(IEntryHolder entry, ITemplateHolder template) {
        return EntryPacketFactory.createFullPacket(template, entry.getEntryData(), entry.getUID(), entry.isTransient());
    }

    public static IEntryPacket createFullPacket(IEntryHolder entry, ITemplateHolder template, IEntryData entryData) {
        return EntryPacketFactory.createFullPacket(template, entryData, entry.getUID(), entry.isTransient());
    }

    public static IEntryPacket createFullPacket(IEntryHolder entry, ITemplateHolder template, String uid) {
        return EntryPacketFactory.createFullPacket(template, entry.getEntryData(), uid, entry.isTransient());
    }

    public static IEntryPacket createFullPacket(ITemplateHolder template, IEntryData entryData, String uid, boolean isTransient) {
        if (entryData.getEntryDataType() == EntryDataType.USER_TYPE) {
            return new LocalCacheResponseEntryPacket((UserTypeEntryData)entryData, uid);
        }
        Object[] fixedProperties = entryData.getFixedPropertiesValues();
        long timeToLive = entryData.getTimeToLive(false);
        return EntryPacketFactory.create(template, isTransient, entryData, fixedProperties, uid, timeToLive, false);
    }

    private static IEntryPacket create(ITemplateHolder template, boolean isTransient, IEntryData entryData, Object[] fixedProperties, String uid, long timeToLive, boolean forceNonExternalizable) {
        return EntryPacketFactory.createInternal(template, isTransient, entryData, fixedProperties, uid, timeToLive, QueryResultTypeInternal.NOT_SET, forceNonExternalizable);
    }

    public static IEntryPacket createRemovePacketForPersistency(IEntryHolder entryHolder, OperationID operationID) {
        IEntryData entryData = entryHolder.getEntryData();
        Object[] fieldValues = EntryPacketFactory.getPartialFieldValuesForPersistency(entryData);
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacketForReplication(entryHolder, operationID);
        entryPacket.setFieldsValues(fieldValues);
        return entryPacket;
    }

    private static IEntryPacket createInternal(ITemplateHolder template, boolean isTransient, IEntryData entryData, Object[] fixedProperties, String uid, long timeToLive, QueryResultTypeInternal packetType, boolean forceNotExternalizable) {
        boolean isReturnWeaklyTypeProperties;
        ITypeDesc typeDesc = entryData.getEntryTypeDesc().getTypeDesc();
        EntryType entryType = entryData.getEntryTypeDesc().getEntryType();
        if (template != null) {
            packetType = template.getQueryResultType();
        }
        boolean bl = isReturnWeaklyTypeProperties = template != null && (Modifiers.contains(template.getOperationModifiers(), 0x200000) || Modifiers.contains(template.getOperationModifiers(), 0x400000));
        if (packetType == QueryResultTypeInternal.NOT_SET) {
            packetType = QueryResultTypeInternal.fromEntryType(entryType);
        }
        switch (packetType) {
            case OBJECT_JAVA: 
            case DOCUMENT_ENTRY: {
                if (!forceNotExternalizable && typeDesc.isExternalizable() && entryType.isConcrete() && !isReturnWeaklyTypeProperties) {
                    return new ExternalizableEntryPacket(typeDesc, entryType, fixedProperties, entryData.getDynamicProperties(), uid, entryData.getVersion(), timeToLive, isTransient);
                }
                return new EntryPacket(typeDesc, entryType, fixedProperties, entryData.getDynamicProperties(), uid, entryData.getVersion(), timeToLive, isTransient);
            }
            case EXTERNAL_ENTRY: {
                String eeImplClassName = template != null ? template.getExternalEntryImplClassName() : null;
                return new ExternalEntryPacket(typeDesc, entryType, fixedProperties, uid, entryData.getVersion(), timeToLive, isTransient, eeImplClassName);
            }
            case OBJECT_DOTNET: 
            case CPP: 
            case PBS_OLD: {
                return new PbsEntryPacket(typeDesc, entryType, fixedProperties, entryData.getDynamicProperties(), uid, entryData.getVersion(), timeToLive, isTransient);
            }
            case DOCUMENT_DOTNET: {
                Map<String, Object> dynamicProperties = entryData.getDynamicProperties();
                if (entryType != EntryType.DOCUMENT_DOTNET && entryType != EntryType.OBJECT_DOTNET) {
                    fixedProperties = DocumentObjectConverterInternal.instance().convertNonPrimitiveFixedPropertiesToDocuments(fixedProperties, typeDesc);
                    dynamicProperties = DocumentObjectConverterInternal.instance().convertNonPrimitiveDynamicPropertiesToDocuments(dynamicProperties);
                }
                return new PbsEntryPacket(typeDesc, entryType, fixedProperties, dynamicProperties, uid, entryData.getVersion(), timeToLive, isTransient);
            }
        }
        throw new UnsupportedOperationException("Unsupported reply packet type: " + (Object)((Object)packetType));
    }

    private static Object[] getPartialUpdateFieldValues(IEntryData entryData, boolean[] partialUpdatedValuesIndicators) {
        Object[] fieldValues = entryData.getFixedPropertiesValues();
        if (fieldValues != null && fieldValues.length > 0 && partialUpdatedValuesIndicators != null) {
            Object[] partialFieldValues = new Object[fieldValues.length];
            for (int i = 0; i < partialUpdatedValuesIndicators.length; ++i) {
                if (partialUpdatedValuesIndicators[i]) continue;
                partialFieldValues[i] = fieldValues[i];
            }
            fieldValues = partialFieldValues;
        }
        return fieldValues;
    }

    private static Object[] getPartialFieldValuesForPersistency(IEntryData entryData) {
        Object[] fieldValues = entryData.getFixedPropertiesValues();
        if (fieldValues != null && fieldValues.length > 0) {
            Object[] newValues = new Object[fieldValues.length];
            ITypeDesc typeDesc = entryData.getEntryTypeDesc().getTypeDesc();
            int idIndex = typeDesc.getIdentifierPropertyId();
            boolean useFirstIndex = idIndex == -1;
            PropertyInfo[] properties = typeDesc.getProperties();
            for (int i = 0; i < fieldValues.length; ++i) {
                boolean isFirstIndex;
                boolean isPrimitive = ObjectUtils.isPrimitive(properties[i].getTypeName());
                boolean isIdField = !useFirstIndex && i == idIndex;
                boolean bl = isFirstIndex = useFirstIndex && typeDesc.getIndexedPropertyID(i) == 0;
                if (!isPrimitive && !isIdField && !isFirstIndex) continue;
                newValues[i] = fieldValues[i];
            }
            fieldValues = newValues;
        }
        return fieldValues;
    }
}

