/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.transport.AbstractEntryPacket;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

@InternalApi
public class ExternalizableEntryPacket
extends AbstractEntryPacket {
    private static final long serialVersionUID = 1L;
    private static final int NULL_VERSION = Integer.MIN_VALUE;
    private static final long NULL_TTL = Long.MIN_VALUE;
    private Externalizable _object;
    private Object[] _fixedProperties;
    private Map<String, Object> _dynamicProperties;
    private String _uid;
    private int _version = Integer.MIN_VALUE;
    private long _timeToLive = Long.MIN_VALUE;
    private boolean _fifo;
    private Boolean _transient;
    private boolean _noWriteLease;
    private boolean _returnOnlyUIDs;
    private ICustomQuery _customQuery;
    private transient boolean _resetWhenWired;
    private static final short FLAG_UID = 1;
    private static final short FLAG_VERSION = 2;
    private static final short FLAG_TIME_TO_LIVE = 4;
    private static final short FLAG_FIFO = 8;
    private static final short FLAG_TRNASIENT = 16;
    private static final short FLAG_NO_WRITE_LEASE = 32;
    private static final short FLAG_RETURN_ONLY_UIDS = 64;
    private static final short FLAG_CUSTOM_QUERY = 128;

    public ExternalizableEntryPacket() {
    }

    public ExternalizableEntryPacket(ITypeDesc typeDesc, EntryType entryType, Externalizable object) {
        super(typeDesc, entryType);
        this._object = object;
    }

    public ExternalizableEntryPacket(ITypeDesc typeDesc, EntryType entryType, Object[] fixedProperties, Map<String, Object> dynamicProperties, String uid, int version, long timeToLive, boolean isTransient) {
        super(typeDesc, entryType);
        this.setFieldsValues(fixedProperties);
        this.setDynamicProperties(dynamicProperties);
        this.setUID(uid);
        this.setVersion(version);
        this.setTransient(isTransient);
        this.setTTL(timeToLive);
        this._fifo = false;
        this._noWriteLease = false;
        try {
            this._object = (Externalizable)this.toObject(this._entryType);
        }
        catch (ConversionException e) {
            throw new ProxyInternalSpaceException("Unable to to create new object ot type: [" + this._typeDesc.getTypeName() + "]", e);
        }
        this._resetWhenWired = true;
    }

    @Override
    public TransportPacketType getPacketType() {
        return TransportPacketType.ENTRY_PACKET;
    }

    @Override
    public String getTypeName() {
        if (this._typeDesc != null) {
            return this._typeDesc.getTypeName();
        }
        if (this._object != null) {
            return this._object.getClass().getName();
        }
        return null;
    }

    @Override
    public Object toObject(EntryType entryType, StorageTypeDeserialization storageTypeDeserialization) {
        if (this._object != null && entryType == this._entryType) {
            return this._object;
        }
        return super.toObject(entryType, storageTypeDeserialization);
    }

    @Override
    public Object[] getFieldValues() {
        if (this._object != null) {
            return this.getIntrospector().getSerializedValues(this._object);
        }
        return this._fixedProperties;
    }

    @Override
    public void setFieldsValues(Object[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this._object == null) {
            this._fixedProperties = values;
        } else {
            this.getIntrospector().setValues(this._object, values);
            this._fixedProperties = null;
        }
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        if (this._object != null) {
            return this.getIntrospector().getDynamicProperties(this._object);
        }
        return this._dynamicProperties;
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        if (dynamicProperties == null || dynamicProperties.isEmpty()) {
            return;
        }
        if (this._object == null) {
            this._dynamicProperties = dynamicProperties;
        } else {
            this.getIntrospector().setDynamicProperties(this._object, dynamicProperties);
            this._dynamicProperties = null;
        }
    }

    @Override
    public Object getFieldValue(int index) {
        if (this._object != null) {
            return this.getIntrospector().getValue((Object)this._object, index);
        }
        return this._fixedProperties != null ? this._fixedProperties[index] : null;
    }

    @Override
    public void setFieldValue(int index, Object value) {
        this.getIntrospector().setValue((Object)this._object, value, index);
    }

    @Override
    public String getUID() {
        if (this._uid != null) {
            return this._uid;
        }
        return this._object != null ? this.getIntrospector().getUID(this._object, this.isTemplate(), true) : null;
    }

    @Override
    public void setUID(String uid) {
        this._uid = uid;
        if (this._object != null) {
            this.getIntrospector().setUID(this._object, uid);
        }
    }

    @Override
    public int getVersion() {
        if (this._version != Integer.MIN_VALUE) {
            return this._version;
        }
        return this._object != null ? this.getIntrospector().getVersion(this._object) : 0;
    }

    @Override
    public void setVersion(int version) {
        this._version = this._object == null || !this.getIntrospector().setVersion(this._object, version) ? version : Integer.MIN_VALUE;
    }

    @Override
    public long getTTL() {
        if (this._timeToLive != Long.MIN_VALUE) {
            return this._timeToLive;
        }
        return this._object != null ? this.getIntrospector().getTimeToLive(this._object) : Long.MAX_VALUE;
    }

    @Override
    public void setTTL(long ttl) {
        this._timeToLive = this._object == null || !this.getIntrospector().setTimeToLive(this._object, ttl) ? ttl : Long.MIN_VALUE;
    }

    @Override
    public boolean isFifo() {
        return this._fifo;
    }

    @Override
    public boolean isTransient() {
        if (this._transient != null) {
            return this._transient;
        }
        return this._object != null ? this.getIntrospector().isTransient(this._object) : false;
    }

    private void setTransient(boolean isTransient) {
        this._transient = this._object == null || !this.getIntrospector().setTransient(this._object, isTransient) ? Boolean.valueOf(isTransient) : null;
    }

    @Override
    public boolean isNoWriteLease() {
        return this._noWriteLease;
    }

    @Override
    public String[] getMultipleUIDs() {
        return null;
    }

    @Override
    public void setMultipleUIDs(String[] uids) {
    }

    public boolean isReturnOnlyUids() {
        return this._returnOnlyUIDs;
    }

    public void setReturnOnlyUIDs(boolean returnOnlyUIDs) {
        this._returnOnlyUIDs = returnOnlyUIDs;
    }

    @Override
    public ICustomQuery getCustomQuery() {
        return this._customQuery;
    }

    @Override
    public void setCustomQuery(ICustomQuery customQuery) {
        this._customQuery = customQuery;
    }

    protected boolean isTemplate() {
        return false;
    }

    private ITypeIntrospector<Object> getIntrospector() {
        return this._typeDesc.getIntrospector(this._entryType);
    }

    private void clearUneededSerializedData() {
        if (this._resetWhenWired && this._object != null && this._typeDesc != null) {
            this._fixedProperties = null;
            this._dynamicProperties = null;
            if (this.getIntrospector().hasVersionProperty(this._object)) {
                this._version = Integer.MIN_VALUE;
            }
            if (this.getIntrospector().hasTimeToLiveProperty(this._object)) {
                this._timeToLive = Long.MIN_VALUE;
            }
            if (this.getIntrospector().hasTransientProperty(this._object)) {
                this._transient = null;
            }
        }
    }

    @Override
    public boolean hasFixedPropertiesArray() {
        return false;
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        this.clearUneededSerializedData();
        super.writeExternal(out, version);
        this.serialize(out);
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        this.clearUneededSerializedData();
        super.writeToSwap(out);
        this.serialize(out);
    }

    private final void serialize(ObjectOutput out) throws IOException {
        short flags = this.buildFlags();
        out.writeShort(flags);
        out.writeObject(this._object);
        if (flags == 0) {
            return;
        }
        if (this._uid != null) {
            IOUtils.writeString(out, this._uid);
        }
        if (this._version != Integer.MIN_VALUE) {
            out.writeInt(this._version);
        }
        if (this._timeToLive != Long.MIN_VALUE) {
            out.writeLong(this._timeToLive);
        }
        if (this._fifo) {
            out.writeBoolean(this._fifo);
        }
        if (this._transient != null) {
            out.writeBoolean(this._transient);
        }
        if (this._noWriteLease) {
            out.writeBoolean(this._noWriteLease);
        }
        if (this._customQuery != null) {
            IOUtils.writeObject(out, this._customQuery);
        }
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserialize(in);
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserialize(in);
    }

    private final void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        this._object = (Externalizable)in.readObject();
        if (flags == 0) {
            return;
        }
        if ((flags & 1) != 0) {
            this._uid = IOUtils.readString(in);
        }
        if ((flags & 2) != 0) {
            this._version = in.readInt();
        }
        if ((flags & 4) != 0) {
            this._timeToLive = in.readLong();
        }
        if ((flags & 8) != 0) {
            this._fifo = in.readBoolean();
        }
        if ((flags & 0x10) != 0) {
            this._transient = in.readBoolean();
        }
        if ((flags & 0x20) != 0) {
            this._noWriteLease = in.readBoolean();
        }
        boolean bl = this._returnOnlyUIDs = (flags & 0x40) != 0;
        if ((flags & 0x80) != 0) {
            this._customQuery = (ICustomQuery)IOUtils.readObject(in);
        }
    }

    private short buildFlags() {
        short flags = 0;
        if (this._uid != null) {
            flags = (short)(flags | 1);
        }
        if (this._version != Integer.MIN_VALUE) {
            flags = (short)(flags | 2);
        }
        if (this._timeToLive != Long.MIN_VALUE) {
            flags = (short)(flags | 4);
        }
        if (this._fifo) {
            flags = (short)(flags | 8);
        }
        if (this._transient != null) {
            flags = (short)(flags | 0x10);
        }
        if (this._noWriteLease) {
            flags = (short)(flags | 0x20);
        }
        if (this._returnOnlyUIDs) {
            flags = (short)(flags | 0x40);
        }
        if (this._customQuery != null) {
            flags = (short)(flags | 0x80);
        }
        return flags;
    }

    @Override
    public void toText(Textualizer textualizer) {
        if (this._typeDesc != null && this.getIntrospector() != null) {
            super.toText(textualizer);
        } else {
            textualizer.append("typeName", this.getTypeName());
            textualizer.append("uid", this._uid);
            textualizer.append("version", this._version);
            textualizer.append("object", this._object);
        }
    }

    @Override
    public boolean isExternalizableEntryPacket() {
        return true;
    }
}

