/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ObjectShortMap;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;

@InternalApi
public class MutliProjectionByUids
extends AbstractProjectionTemplate {
    private static final long serialVersionUID = -3375363086422585765L;
    AbstractProjectionTemplate[] _projections;
    ObjectShortMap<String> _uidsByProjection;

    public MutliProjectionByUids(AbstractProjectionTemplate[] projections, ObjectShortMap<String> uidsByProjection) {
        this._projections = projections;
        this._uidsByProjection = uidsByProjection;
    }

    public MutliProjectionByUids() {
    }

    @Override
    public void filterOutNonProjectionProperties(IEntryPacket entryPacket) {
        if (!this._uidsByProjection.containsKey(entryPacket.getUID())) {
            return;
        }
        short pos = this._uidsByProjection.get(entryPacket.getUID());
        this._projections[pos].filterOutNonProjectionProperties(entryPacket);
    }

    @Override
    public int[] getFixedPropertiesIndexes() {
        return null;
    }

    @Override
    public String[] getDynamicProperties() {
        return null;
    }

    @Override
    public String[] getFixedPaths() {
        return null;
    }

    @Override
    public String[] getDynamicPaths() {
        return null;
    }

    @Override
    public boolean isMultiUidsProjection() {
        return true;
    }

    @Override
    public boolean isAllIndexesProjections(IServerTypeDesc serverTypeDesc, ITemplateHolder templateHolder, String uid) {
        if (!this._uidsByProjection.containsKey(uid)) {
            return false;
        }
        short pos = this._uidsByProjection.get(uid);
        return this._projections[pos].isAllIndexesProjections(serverTypeDesc, templateHolder);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._projections);
        this._uidsByProjection.serialize(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._projections = (AbstractProjectionTemplate[])in.readObject();
        this._uidsByProjection = CollectionsFactory.getInstance().deserializeObjectShortMap(in);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._projections);
        result = 31 * result + this._uidsByProjection.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutliProjectionByUids other = (MutliProjectionByUids)obj;
        if (!Arrays.equals(this._projections, other._projections)) {
            return false;
        }
        return this._uidsByProjection.equals(other._uidsByProjection);
    }

    private int[] toIntArray(List<Integer> list) {
        int[] res = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = list.get(i);
        }
        return res;
    }
}

