/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import net.jini.space.InternalSpaceException;

@InternalApi
public class PathProjectionInfo {
    private final String _fullPath;
    private final String[] _tokens;
    private final boolean[] _collectionsIndicators;
    private static final String COLLECTION_STRING = "[*]";

    PathProjectionInfo(String fullPath) {
        this._fullPath = fullPath;
        this._tokens = fullPath.split("\\.");
        if (this._tokens == null || this._tokens.length == 0) {
            throw new InternalSpaceException("Error splitting property path [" + fullPath + "].");
        }
        this._collectionsIndicators = new boolean[this._tokens.length];
        for (int i = 0; i < this._tokens.length; ++i) {
            String token = PathProjectionInfo.removeCollectionInfoIfExist(this._tokens[i]);
            if (this._tokens[i] == token) continue;
            this._tokens[i] = token;
            this._collectionsIndicators[i] = true;
        }
    }

    String getFullPath() {
        return this._fullPath;
    }

    String[] getTokens() {
        return this._tokens;
    }

    int getDepth() {
        return this._tokens.length;
    }

    boolean[] getCollectionIndicators() {
        return this._collectionsIndicators;
    }

    static String removeCollectionInfoIfExist(String token) {
        while (token.endsWith(COLLECTION_STRING)) {
            token = token.substring(0, token.length() - COLLECTION_STRING.length());
            token.trim();
        }
        return token;
    }
}

