/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.PathProjectionInfo;
import com.gigaspaces.internal.transport.PathsProjectionNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public class PathsProjectionHandler {
    private final HashMap<String, PathsProjectionNode> _roots;
    private final List<Integer> _fixedProperties;
    private final List<String> _dynamicProperties;

    public PathsProjectionHandler(String[] fixedPaths, String[] dynamicPaths, ITypeDesc typeDesc) {
        ArrayList<Integer> fixedProperties = null;
        ArrayList<String> dynamicProperties = null;
        HashMap<String, ArrayList<PathProjectionInfo>> devidedPaths = new HashMap<String, ArrayList<PathProjectionInfo>>();
        if (fixedPaths != null) {
            fixedProperties = new ArrayList<Integer>(fixedPaths.length);
            for (int i = 0; i < fixedPaths.length; ++i) {
                PathProjectionInfo pi = new PathProjectionInfo(fixedPaths[i]);
                ArrayList<PathProjectionInfo> cur = (ArrayList<PathProjectionInfo>)devidedPaths.get(pi.getTokens()[0]);
                if (cur == null) {
                    cur = new ArrayList<PathProjectionInfo>(fixedPaths.length);
                    devidedPaths.put(pi.getTokens()[0], cur);
                }
                cur.add(pi);
                fixedProperties.add(typeDesc.getFixedPropertyPosition(pi.getTokens()[0]));
            }
        }
        if (dynamicPaths != null) {
            dynamicProperties = new ArrayList<String>(dynamicPaths.length);
            for (String dynamicPath : dynamicPaths) {
                PathProjectionInfo pi = new PathProjectionInfo(dynamicPath);
                ArrayList<PathProjectionInfo> cur = (ArrayList<PathProjectionInfo>)devidedPaths.get(pi.getTokens()[0]);
                if (cur == null) {
                    cur = new ArrayList<PathProjectionInfo>(dynamicPaths.length);
                    devidedPaths.put(pi.getTokens()[0], cur);
                }
                cur.add(pi);
                dynamicProperties.add(pi.getTokens()[0]);
            }
        }
        HashMap roots = new HashMap();
        for (Map.Entry mapEntry : devidedPaths.entrySet()) {
            roots.put(mapEntry.getKey(), new PathsProjectionNode((String)mapEntry.getKey(), 0, (List)mapEntry.getValue()));
        }
        this._roots = roots;
        this._fixedProperties = fixedProperties;
        this._dynamicProperties = dynamicProperties;
    }

    public void applyFixedPathsProjections(IEntryPacket entryPacket, Object[] projectedValues) {
        for (int i : this._fixedProperties) {
            Object newValue;
            String property = entryPacket.getTypeDescriptor().getFixedProperty(i).getName();
            projectedValues[i] = newValue = this.buildProjectedPath(property, entryPacket.getFieldValue(i));
        }
    }

    public void applyFixedPathsProjections(IEntryData entryData, Object[] projectedValues) {
        for (int i : this._fixedProperties) {
            Object newValue;
            String property = entryData.getEntryTypeDesc().getTypeDesc().getFixedProperty(i).getName();
            projectedValues[i] = newValue = this.buildProjectedPath(property, entryData.getFixedPropertiesValues()[i]);
        }
    }

    public void applyDynamicPathsProjections(IEntryPacket entryPacket, Map<String, Object> projectedDynamicProperties) {
        for (String property : this._dynamicProperties) {
            Object newValue = this.buildProjectedPath(property, entryPacket.getDynamicProperties().get(property));
            projectedDynamicProperties.put(property, newValue);
        }
    }

    private Object buildProjectedPath(String property, Object value) {
        if (value == null) {
            return null;
        }
        PathsProjectionNode n = this._roots.get(property);
        if (n == null) {
            return null;
        }
        return n.buildProjectedPath(value);
    }
}

