/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.entry.VirtualEntry;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.transport.PathProjectionInfo;
import com.gigaspaces.metadata.SpaceMetadataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class PathsProjectionNode {
    private final String[] _tokens;
    private volatile SpacePropertyInfo[] _propertyInfo = new SpacePropertyInfo[1];
    private final List<PathsProjectionNode> _pathsProjectionSubTree;
    private final boolean _bottom;
    private final String _firstFullPath;
    private final PathProjectionInfo _projectionInfo;
    private final int _pos;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.metadata.pojo");

    PathsProjectionNode(String property, int pos, List<PathProjectionInfo> paths) {
        String[] tokens = new String[]{property};
        this._tokens = tokens;
        this._pos = pos;
        this._bottom = paths.size() == 1 && (paths.get(0).getDepth() == pos + 1 || paths.get(0).getDepth() == pos + 2 && paths.get(0).getTokens()[pos + 1].isEmpty());
        this._firstFullPath = paths.get(0).getFullPath();
        this._projectionInfo = paths.get(0);
        if (this.isBottom()) {
            this._pathsProjectionSubTree = null;
            return;
        }
        boolean isCollection = false;
        LinkedList<PathsProjectionNode> pathsProjectionSubTree = new LinkedList<PathsProjectionNode>();
        HashMap devidedPaths = new HashMap();
        for (PathProjectionInfo pathProjectionInfo : paths) {
            if (pathProjectionInfo.getDepth() == pos + 1) {
                throw new RuntimeException("invalid projection settings " + pathProjectionInfo.getFullPath() + " other projections exist on same root");
            }
            ArrayList<PathProjectionInfo> cur = (ArrayList<PathProjectionInfo>)devidedPaths.get(pathProjectionInfo.getTokens()[pos + 1]);
            if (cur != null) {
                if (pathProjectionInfo.getDepth() == pos + 2 || ((PathProjectionInfo)cur.get(0)).getDepth() == pos + 2) {
                    throw new RuntimeException("invalid projection settings both " + pathProjectionInfo.getFullPath() + " and " + ((PathProjectionInfo)cur.get(0)).getFullPath());
                }
            } else {
                cur = new ArrayList<PathProjectionInfo>(2);
                devidedPaths.put(pathProjectionInfo.getTokens()[pos + 1], cur);
            }
            cur.add(pathProjectionInfo);
            if (!pathProjectionInfo.getCollectionIndicators()[this._pos]) continue;
            isCollection = true;
        }
        for (Map.Entry entry : devidedPaths.entrySet()) {
            pathsProjectionSubTree.add(new PathsProjectionNode((String)entry.getKey(), pos + 1, (List)entry.getValue()));
        }
        this._pathsProjectionSubTree = pathsProjectionSubTree;
    }

    String getPropertyName() {
        return this._tokens[0];
    }

    SpacePropertyInfo getPropertyInfo() {
        return this._propertyInfo != null ? this._propertyInfo[0] : null;
    }

    boolean isBottom() {
        return this._bottom;
    }

    private boolean isRoot() {
        return this._pos == 0;
    }

    public String getFullPath() {
        return this._firstFullPath;
    }

    private boolean isCollectionDefined() {
        return this._projectionInfo.getCollectionIndicators()[this._pos];
    }

    Object buildProjectedPath(Object value) {
        if (value == null) {
            return null;
        }
        Object originalValue = null;
        originalValue = this.isRoot() ? value : (value instanceof Map ? ((Map)value).get(this._projectionInfo.getTokens()[this._pos]) : (value instanceof VirtualEntry ? ((VirtualEntry)value).getProperty(this._projectionInfo.getTokens()[this._pos]) : AbstractTypeIntrospector.getNestedValue(value, 0, this._tokens, this._propertyInfo, this.getFullPath())));
        if (originalValue == null) {
            return null;
        }
        if (originalValue instanceof Collection) {
            Collection c = (Collection)originalValue;
            Class<?> ctype = originalValue.getClass();
            Collection newC = null;
            try {
                newC = (Collection)ctype.newInstance();
            }
            catch (InstantiationException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
            }
            for (Object originalMember : c) {
                Object newMember;
                if (originalMember == null || (newMember = this.buildSubObject(originalMember)) == null) continue;
                newC.add(newMember);
            }
            return newC;
        }
        if (this.isCollectionDefined()) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "property declared as collection using [*] notation but is not [" + this._tokens[this._pos] + "]");
            }
            throw new SpaceMetadataException("property declared as collection using [*] notation but is not [" + this._tokens[this._pos] + "] ");
        }
        return this.buildSubObject(originalValue);
    }

    private Object buildSubObject(Object originalValue) {
        if (this.isBottom()) {
            return originalValue;
        }
        if (originalValue instanceof Collection) {
            Collection c = (Collection)originalValue;
            Class<?> ctype = originalValue.getClass();
            Collection newC = null;
            try {
                newC = (Collection)ctype.newInstance();
            }
            catch (InstantiationException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + ctype.getName() + "]: " + e.getMessage(), e);
            }
            for (Object originalMember : c) {
                Object newMember;
                if (originalMember == null || (newMember = this.buildSubObject(originalMember)) == null) continue;
                newC.add(newMember);
            }
            return newC;
        }
        if (originalValue instanceof Map) {
            Map m = (Map)originalValue;
            Class<?> mtype = originalValue.getClass();
            Map newM = null;
            try {
                newM = (Map)mtype.newInstance();
            }
            catch (InstantiationException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + mtype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + mtype.getName() + "]: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + mtype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + mtype.getName() + "]: " + e.getMessage(), e);
            }
            for (PathsProjectionNode under : this._pathsProjectionSubTree) {
                Object subval = under.buildProjectedPath(originalValue);
                newM.put(under.getPropertyName(), subval);
            }
            return newM;
        }
        if (originalValue instanceof VirtualEntry) {
            VirtualEntry v = (VirtualEntry)originalValue;
            Class<?> vetype = originalValue.getClass();
            VirtualEntry newVE = null;
            try {
                newVE = (VirtualEntry)vetype.newInstance();
            }
            catch (InstantiationException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + vetype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + vetype.getName() + "]: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create instance of type [" + vetype.getName() + "]: " + e.getMessage(), e);
                }
                throw new SpaceMetadataException("Failed to create instance of type [" + vetype.getName() + "]: " + e.getMessage(), e);
            }
            newVE.setTypeName(v.getTypeName());
            newVE.setTransient(v.isTransient());
            newVE.setVersion(v.getVersion());
            for (PathsProjectionNode under : this._pathsProjectionSubTree) {
                Object subval = under.buildProjectedPath(originalValue);
                if (subval == null && !v.containsProperty(under.getPropertyName())) continue;
                newVE.setProperty(under.getPropertyName(), subval);
            }
            return newVE;
        }
        Class<?> type = originalValue.getClass();
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(type);
        Object newVal = typeInfo.createInstance();
        for (PathsProjectionNode under : this._pathsProjectionSubTree) {
            Object subval = under.buildProjectedPath(originalValue);
            under.getPropertyInfo().setValue(newVal, subval);
        }
        return newVal;
    }
}

