/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.transport.AbstractEntryPacket;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.TransportPacketType;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.serialization.pbs.PbsEntryFormatter;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsOutputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

@InternalApi
public class PbsEntryPacket
extends AbstractEntryPacket {
    private static final long serialVersionUID = 1L;
    protected static final byte CONTENT_NONE = 0;
    protected static final byte CONTENT_HEADER = 1;
    protected static final byte CONTENT_ALL = 2;
    protected String _className;
    private String _uid;
    private int _version;
    private long _timeToLive;
    private boolean _fifo;
    private boolean _transient;
    private boolean _noWriteLease;
    protected Object[] _fieldsValues;
    private String[] _multipleUIDs;
    private boolean _returnOnlyUIDs;
    private byte[] _marshedContent;
    protected byte _unmarshContentState;
    private int _unmarshedContentLength = 0;
    protected Object _routingFieldValue;
    private Map<String, Object> _dynamicProperties;
    private ICustomQuery _customQuery;
    private boolean _dirtyHeader;
    private static final short FLAG_MARSHED_CONTENT = 1;
    private static final short FLAG_MULTIPLE_UIDS = 2;
    private static final short FLAG_TIME_TO_LIVE = 4;
    private static final short FLAG_NO_WRITE_LEASE = 8;
    private static final short FLAG_RETURN_ONLY_UIDS = 16;
    private static final short FLAG_DYNAMIC_PROPERTIES = 32;
    private static final short FLAG_CUSTOM_QUERY = 64;

    public PbsEntryPacket() {
    }

    public PbsEntryPacket(ITypeDesc typeDesc, EntryType entryType) {
        super(typeDesc, entryType);
        this._className = typeDesc != null ? typeDesc.getTypeName() : null;
    }

    public PbsEntryPacket(PbsInputStream input, ITypeDesc typeDesc, EntryType entryType) {
        this(typeDesc, entryType);
        this.readHeader(input);
        this.readFixedProperties(input);
    }

    public PbsEntryPacket(byte[] byteStream, Map<String, Object> dynamicProperties, EntryType entryType) {
        this(null, entryType);
        this._marshedContent = byteStream;
        this._dynamicProperties = dynamicProperties;
        this._unmarshContentState = 0;
    }

    public PbsEntryPacket(ITypeDesc typeDesc, EntryType entryType, Object[] fixedProperties, Map<String, Object> dynamicProperties, String uid, int version, long timeToLive, boolean isTransient) {
        this(typeDesc, entryType);
        this._uid = uid;
        this._fieldsValues = fixedProperties;
        this._dynamicProperties = dynamicProperties;
        this._version = version;
        this._timeToLive = timeToLive;
        this._transient = isTransient;
        this._noWriteLease = false;
        this._fifo = false;
        this._unmarshContentState = (byte)2;
    }

    @Override
    public IEntryPacket clone() {
        Object[] fieldsValues = this.getFieldValues();
        IEntryPacket packet = super.clone();
        if (fieldsValues != null) {
            packet.setFieldsValues((Object[])fieldsValues.clone());
        }
        return packet;
    }

    public byte[] getStreamBytes() {
        this.marsh();
        return this._marshedContent;
    }

    @Override
    public TransportPacketType getPacketType() {
        return TransportPacketType.PBS;
    }

    @Override
    public String[] getMultipleUIDs() {
        return this._multipleUIDs;
    }

    @Override
    public void setMultipleUIDs(String[] multipleUIDs) {
        this._multipleUIDs = multipleUIDs;
    }

    public boolean isReturnOnlyUids() {
        return this._returnOnlyUIDs;
    }

    public void setReturnOnlyUIDs(boolean returnOnlyUIDs) {
        this._returnOnlyUIDs = returnOnlyUIDs;
    }

    @Override
    public long getTTL() {
        return this._timeToLive;
    }

    @Override
    public void setTTL(long ttl) {
        this._timeToLive = ttl;
    }

    @Override
    public boolean isNoWriteLease() {
        return this._noWriteLease;
    }

    @Override
    public String getTypeName() {
        this.unmarsh((byte)1);
        return this._className;
    }

    @Override
    public String getUID() {
        this.unmarsh((byte)1);
        return this._uid;
    }

    @Override
    public void setUID(String uid) {
        this._dirtyHeader = true;
        this._uid = uid;
    }

    @Override
    public int getVersion() {
        this.unmarsh((byte)1);
        return this._version;
    }

    @Override
    public void setVersion(int version) {
        if (this.getVersion() != version) {
            this._dirtyHeader = true;
            this._version = version;
        }
    }

    @Override
    public boolean isFifo() {
        this.unmarsh((byte)1);
        return this._fifo;
    }

    @Override
    public boolean isTransient() {
        this.unmarsh((byte)1);
        return this._transient;
    }

    @Override
    public Object getRoutingFieldValue() {
        if (this._typeDesc.isAutoGenerateRouting()) {
            return SpaceUidFactory.extractPartitionId(this.getUID());
        }
        this.unmarsh((byte)1);
        if (this._routingFieldValue == null && this._typeDesc.getRoutingPropertyId() != -1) {
            this.unmarsh((byte)2);
            return this.getFieldValue(this._typeDesc.getRoutingPropertyId());
        }
        return this._routingFieldValue;
    }

    @Override
    public Object[] getFieldValues() {
        this.unmarsh((byte)2);
        return this._fieldsValues;
    }

    @Override
    public void setFieldsValues(Object[] values) {
        this._dirtyHeader = true;
        this._fieldsValues = values;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._dynamicProperties;
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        this._dynamicProperties = dynamicProperties;
    }

    @Override
    public Object getFieldValue(int index) {
        return this.getFieldValues()[index];
    }

    @Override
    public void setFieldValue(int index, Object value) {
        try {
            this._fieldsValues[index] = value;
        }
        catch (Exception e) {
            throw new IllegalStateException("The field values array was not properly set", e);
        }
    }

    @Override
    public boolean supportsTypeDescChecksum() {
        return false;
    }

    @Override
    public int getTypeDescChecksum() {
        throw new IllegalStateException();
    }

    @Override
    public ICustomQuery getCustomQuery() {
        return this._customQuery;
    }

    @Override
    public void setCustomQuery(ICustomQuery customQuery) {
        this._customQuery = customQuery;
    }

    @Override
    public boolean hasFixedPropertiesArray() {
        return true;
    }

    private void marsh() {
        if (this._dirtyHeader) {
            this.unmarsh((byte)2);
            this._marshedContent = null;
            this._dirtyHeader = false;
        }
        if (this._marshedContent == null) {
            PbsOutputStream output = PbsStreamResource.getOutputStream();
            try {
                PbsEntryFormatter.writeEntry(output, this._fieldsValues, this._className, this._uid, this._version, this._transient, this._fifo, false);
                this._marshedContent = output.toByteArray();
            }
            finally {
                PbsStreamResource.releasePbsStream(output);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarsh(byte requiredContent) {
        if (this._unmarshContentState < requiredContent && this._marshedContent != null) {
            PbsInputStream input = PbsStreamResource.getInputStream(this._marshedContent);
            try {
                int totalContentLength = input.available();
                if (this._unmarshedContentLength > 0) {
                    input.skip(this._unmarshedContentLength);
                }
                if (this._unmarshContentState < 1 && requiredContent >= 1) {
                    this.readHeader(input);
                    this._unmarshContentState = 1;
                    this._unmarshedContentLength = totalContentLength - input.available();
                    if (requiredContent == 1) {
                        return;
                    }
                }
                if (this._unmarshContentState < 2 && requiredContent >= 2) {
                    this.readFixedProperties(input);
                    this._unmarshContentState = (byte)2;
                    this._unmarshedContentLength = totalContentLength - input.available();
                }
            }
            finally {
                PbsStreamResource.releasePbsStream(input);
            }
        }
    }

    private void readHeader(PbsInputStream input) {
        short pbsVersion = input.readShort();
        this._className = input.readString();
        String uid = input.readString();
        this._uid = uid != null && uid.length() == 0 ? null : uid;
        int version = input.readInt();
        this._version = version == -1 ? 0 : version;
        int flags = input.readInt();
        boolean hasMetadata = (flags & 0x10) != 0;
        this._transient = (flags & 1) != 0;
        boolean bl = this._fifo = (flags & 4) != 0;
        if (hasMetadata) {
            this._typeDesc = PbsEntryFormatter.readTypeDesc(input, this._className, this.getEntryType(), flags);
        }
        this._routingFieldValue = PbsEntryFormatter.readFieldValue(input);
    }

    private void readFixedProperties(PbsInputStream input) {
        int length = input.readInt();
        this._fieldsValues = new Object[length];
        for (int i = 0; i < length; ++i) {
            this._fieldsValues[i] = PbsEntryFormatter.readFieldValue(input);
        }
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.deserializePacket(in);
    }

    private final void deserializePacket(ObjectInput in) throws IOException, ClassNotFoundException {
        short flags = in.readShort();
        if ((flags & 1) != 0) {
            this._marshedContent = IOUtils.readByteArray(in);
        }
        if ((flags & 2) != 0) {
            this._multipleUIDs = IOUtils.readStringArray(in);
        }
        if ((flags & 4) != 0) {
            this._timeToLive = in.readLong();
        }
        if ((flags & 0x20) != 0) {
            this._dynamicProperties = (Map)IOUtils.readObject(in);
        }
        if ((flags & 0x40) != 0) {
            this._customQuery = (ICustomQuery)IOUtils.readObject(in);
        }
        this._noWriteLease = (flags & 8) != 0;
        this._returnOnlyUIDs = (flags & 0x10) != 0;
    }

    @Override
    public void writeToSwap(ObjectOutput out) throws IOException {
        super.writeToSwap(out);
        this.serializePacket(out, PlatformLogicalVersion.getLogicalVersion());
    }

    @Override
    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readFromSwap(in);
        this.deserializePacket(in);
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.serializePacket(out, version);
    }

    private final void serializePacket(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        this.marsh();
        short flags = this.buildFlags(version);
        out.writeShort(flags);
        if (this._marshedContent != null) {
            IOUtils.writeByteArray(out, this._marshedContent);
        }
        if (this._multipleUIDs != null) {
            IOUtils.writeStringArray(out, this._multipleUIDs);
        }
        if (this._timeToLive != 0L) {
            out.writeLong(this._timeToLive);
        }
        if ((flags & 0x20) != 0) {
            IOUtils.writeObject(out, this._dynamicProperties);
        }
        if ((flags & 0x40) != 0) {
            IOUtils.writeObject(out, this._customQuery);
        }
    }

    private short buildFlags(PlatformLogicalVersion version) {
        short flags = 0;
        if (this._marshedContent != null) {
            flags = (short)(flags | 1);
        }
        if (this._multipleUIDs != null) {
            flags = (short)(flags | 2);
        }
        if (this._timeToLive != 0L) {
            flags = (short)(flags | 4);
        }
        if (this._noWriteLease) {
            flags = (short)(flags | 8);
        }
        if (this._returnOnlyUIDs) {
            flags = (short)(flags | 0x10);
        }
        if (this._dynamicProperties != null) {
            flags = (short)(flags | 0x20);
        }
        if (this._customQuery != null) {
            flags = (short)(flags | 0x40);
        }
        return flags;
    }
}

