/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.serialization.pbs.PbsInputStream;
import com.gigaspaces.serialization.pbs.PbsStreamResource;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class PbsProjectionTemplate
extends AbstractProjectionTemplate {
    private static final long serialVersionUID = 1L;
    private byte[] _serializedFixedPropertiesIndexes;
    private String[] _dynamicProperties;
    private String[] _fixedPaths;
    private String[] _dynamicPaths;
    private transient int[] _fixedPropertiesIndexes;
    private transient boolean _unmarshed;

    public PbsProjectionTemplate() {
    }

    public PbsProjectionTemplate(byte[] serializedFixedPropertiesIndexes, String[] dynamicProperties, String[] fixedPaths, String[] dynamicPaths) {
        this._serializedFixedPropertiesIndexes = serializedFixedPropertiesIndexes;
        this._dynamicProperties = dynamicProperties;
        this._fixedPaths = fixedPaths;
        this._dynamicPaths = dynamicPaths;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._serializedFixedPropertiesIndexes = IOUtils.readByteArray(in);
        this._dynamicProperties = IOUtils.readRepetitiveStringArray(in);
        PlatformLogicalVersion endpointVersion = LRMIInvocationContext.getEndpointLogicalVersion();
        if (endpointVersion.greaterOrEquals(PlatformLogicalVersion.v9_7_0) || endpointVersion.patchSameOrGreater(PlatformLogicalVersion.v9_6_2_PATCH3)) {
            this._fixedPaths = IOUtils.readRepetitiveStringArray(in);
            this._dynamicPaths = IOUtils.readRepetitiveStringArray(in);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeByteArray(out, this._serializedFixedPropertiesIndexes);
        IOUtils.writeRepetitiveStringArray(out, this._dynamicProperties);
        PlatformLogicalVersion endpointVersion = LRMIInvocationContext.getEndpointLogicalVersion();
        if (endpointVersion.greaterOrEquals(PlatformLogicalVersion.v9_7_0) || endpointVersion.patchSameOrGreater(PlatformLogicalVersion.v9_6_2_PATCH3)) {
            IOUtils.writeRepetitiveStringArray(out, this._fixedPaths);
            IOUtils.writeRepetitiveStringArray(out, this._dynamicPaths);
        } else if (this._fixedPaths != null || this._dynamicPaths != null) {
            throw new UnsupportedOperationException("server version do not support paths projection");
        }
    }

    @Override
    public int[] getFixedPropertiesIndexes() {
        if (!this._unmarshed) {
            this.unmarsh();
        }
        return this._fixedPropertiesIndexes;
    }

    private void unmarsh() {
        if (this._serializedFixedPropertiesIndexes == null) {
            this._unmarshed = true;
            return;
        }
        PbsInputStream input = PbsStreamResource.getInputStream(this._serializedFixedPropertiesIndexes);
        try {
            this._fixedPropertiesIndexes = input.readIntArray();
            this._unmarshed = true;
        }
        finally {
            PbsStreamResource.releasePbsStream(input);
        }
    }

    @Override
    public String[] getDynamicProperties() {
        return this._dynamicProperties;
    }

    @Override
    public String[] getFixedPaths() {
        return this._fixedPaths;
    }

    @Override
    public String[] getDynamicPaths() {
        return this._dynamicPaths;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._dynamicProperties);
        result = 31 * result + Arrays.hashCode(this._serializedFixedPropertiesIndexes);
        result = 31 * result + Arrays.hashCode(this._fixedPaths);
        result = 31 * result + Arrays.hashCode(this._dynamicPaths);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PbsProjectionTemplate other = (PbsProjectionTemplate)obj;
        if (!Arrays.equals(this._dynamicProperties, other._dynamicProperties)) {
            return false;
        }
        if (!Arrays.equals(this._serializedFixedPropertiesIndexes, other._serializedFixedPropertiesIndexes)) {
            return false;
        }
        if (!Arrays.equals(this._fixedPaths, other._fixedPaths)) {
            return false;
        }
        return Arrays.equals(this._dynamicPaths, other._dynamicPaths);
    }

    public String toString() {
        return "PbsProjectionTemplate [fixedPropertiesIndexes=" + (this._fixedPropertiesIndexes != null ? (Object)this._fixedPropertiesIndexes : "serialized") + ", dynamicProperties=" + this._dynamicProperties + ", fixedPaths=" + this._fixedPaths + ", dynamicPaths=" + this._dynamicPaths + "]";
    }
}

