/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerSet;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.PathProjectionInfo;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metadata.StorageType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

@InternalApi
public class ProjectionTemplate
extends AbstractProjectionTemplate {
    private static final long serialVersionUID = 1L;
    private int[] _fixedIndexes;
    private String[] _dynamicProperties;
    private String[] _fixedPaths;
    private String[] _dynamicPaths;

    public ProjectionTemplate() {
    }

    private ProjectionTemplate(int[] fixedIndexes, String[] dynamicProperties, String[] fixedPaths, String[] dynamicPaths) {
        this._fixedIndexes = fixedIndexes;
        this._dynamicProperties = dynamicProperties;
        this._fixedPaths = fixedPaths;
        this._dynamicPaths = dynamicPaths;
    }

    @Override
    public int[] getFixedPropertiesIndexes() {
        return this._fixedIndexes;
    }

    @Override
    public String[] getDynamicProperties() {
        return this._dynamicProperties;
    }

    @Override
    public String[] getFixedPaths() {
        return this._fixedPaths;
    }

    @Override
    public String[] getDynamicPaths() {
        return this._dynamicPaths;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeIntegerArray(out, this._fixedIndexes);
        IOUtils.writeRepetitiveStringArray(out, this._dynamicProperties);
        PlatformLogicalVersion endpointVersion = LRMIInvocationContext.getEndpointLogicalVersion();
        if (endpointVersion.greaterOrEquals(PlatformLogicalVersion.v9_7_0) || endpointVersion.patchSameOrGreater(PlatformLogicalVersion.v9_6_2_PATCH3)) {
            IOUtils.writeRepetitiveStringArray(out, this._fixedPaths);
            IOUtils.writeRepetitiveStringArray(out, this._dynamicPaths);
        } else if (this._fixedPaths != null || this._dynamicPaths != null) {
            throw new UnsupportedOperationException("server version do not support paths projection");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._fixedIndexes = IOUtils.readIntegerArray(in);
        this._dynamicProperties = IOUtils.readRepetitiveStringArray(in);
        PlatformLogicalVersion endpointVersion = LRMIInvocationContext.getEndpointLogicalVersion();
        if (endpointVersion.greaterOrEquals(PlatformLogicalVersion.v9_7_0) || endpointVersion.patchSameOrGreater(PlatformLogicalVersion.v9_6_2_PATCH3)) {
            this._fixedPaths = IOUtils.readRepetitiveStringArray(in);
            this._dynamicPaths = IOUtils.readRepetitiveStringArray(in);
        }
    }

    public static ProjectionTemplate create(String[] projections, ITypeDesc typeDesc) {
        IntegerSet fixedIndexes = null;
        ArrayList<String> dynamicProperties = null;
        ArrayList<String> fixedPaths = null;
        ArrayList<String> dynamicPaths = null;
        HashSet<String> existing = null;
        for (String projection : projections) {
            String token;
            int fixedPropertyPosition = typeDesc.getFixedPropertyPosition(projection);
            if (fixedPropertyPosition != -1) {
                if (fixedIndexes == null) {
                    fixedIndexes = CollectionsFactory.getInstance().createIntegerSet(projections.length);
                }
                fixedIndexes.add(fixedPropertyPosition);
                if (existing == null) {
                    existing = new HashSet<String>();
                }
                existing.add(projection);
                continue;
            }
            int dotPos = projection.indexOf(".");
            if (dotPos == -1) {
                if (dynamicProperties == null) {
                    dynamicProperties = new ArrayList<String>(projections.length);
                }
                dynamicProperties.add(projection);
                if (existing == null) {
                    existing = new HashSet();
                }
                existing.add(projection);
                continue;
            }
            String property = projection.substring(0, dotPos);
            if (existing != null && existing.contains(property)) {
                throw new UnsupportedOperationException("Projection cannot contain both a path and a projection of its root property  [" + projection + "]");
            }
            fixedPropertyPosition = typeDesc.getFixedPropertyPosition(property);
            if (fixedPropertyPosition == -1 && (token = PathProjectionInfo.removeCollectionInfoIfExist(property)) != property) {
                property = token;
                fixedPropertyPosition = typeDesc.getFixedPropertyPosition(property);
            }
            if (fixedPropertyPosition != -1) {
                PropertyInfo pi = typeDesc.getFixedProperty(fixedPropertyPosition);
                if (pi.getStorageType() != StorageType.OBJECT && (pi.getStorageType() != StorageType.DEFAULT || typeDesc.getStorageType() != StorageType.OBJECT)) {
                    throw new UnsupportedOperationException("Projection of paths is valid only with StorageType = OBJECT [" + projection + "]");
                }
                if (fixedPaths == null) {
                    fixedPaths = new ArrayList<String>(projections.length);
                }
                fixedPaths.add(projection);
                continue;
            }
            if (typeDesc.getStorageType() != StorageType.OBJECT) {
                throw new UnsupportedOperationException("Projection of paths is valid only with StorageType = OBJECT [" + projection + "]");
            }
            if (dynamicPaths == null) {
                dynamicPaths = new ArrayList<String>(projections.length);
            }
            dynamicPaths.add(projection);
        }
        int[] fixedIndexesArray = fixedIndexes != null ? fixedIndexes.toArray() : null;
        String[] dynamicPropertiesArray = dynamicProperties != null ? dynamicProperties.toArray(new String[dynamicProperties.size()]) : null;
        String[] fixpathsArray = fixedPaths != null ? fixedPaths.toArray(new String[fixedPaths.size()]) : null;
        String[] dynamicpathsArray = dynamicPaths != null ? dynamicPaths.toArray(new String[dynamicPaths.size()]) : null;
        return new ProjectionTemplate(fixedIndexesArray, dynamicPropertiesArray, fixpathsArray, dynamicpathsArray);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._dynamicProperties);
        result = 31 * result + Arrays.hashCode(this._fixedIndexes);
        result = 31 * result + Arrays.hashCode(this._fixedPaths);
        result = 31 * result + Arrays.hashCode(this._dynamicPaths);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectionTemplate other = (ProjectionTemplate)obj;
        if (!Arrays.equals(this._dynamicProperties, other._dynamicProperties)) {
            return false;
        }
        if (!Arrays.equals(this._fixedIndexes, other._fixedIndexes)) {
            return false;
        }
        if (!Arrays.equals(this._fixedPaths, other._fixedPaths)) {
            return false;
        }
        return Arrays.equals(this._dynamicPaths, other._dynamicPaths);
    }

    public String toString() {
        return "ProjectionTemplate [fixedIndexes=" + this._fixedIndexes + ", dynamicProperties=" + this._dynamicProperties + ", fixedPaths" + this._fixedPaths + ", dynamicPaths" + this._dynamicPaths + "]";
    }
}

