/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.transport;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ExternalEntryIntrospector;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.ITypeIntrospector;
import com.gigaspaces.internal.query.PropertiesQuery;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.EmptyQueryPacket;
import com.gigaspaces.internal.transport.ExternalizableTemplatePacket;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacket;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.j_spaces.core.AbstractIdsQueryPacket;
import com.j_spaces.core.ExternalTemplatePacket;
import com.j_spaces.core.IdQueryPacket;
import com.j_spaces.core.IdsMultiRoutingQueryPacket;
import com.j_spaces.core.IdsQueryPacket;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.UidQueryPacket;
import com.j_spaces.core.client.ExternalEntry;
import java.io.Externalizable;
import java.util.Map;

@InternalApi
public class TemplatePacketFactory {
    public static ITemplatePacket createEmptyPacket(ITypeDesc typeDesc) {
        return new EmptyQueryPacket(typeDesc);
    }

    public static ITemplatePacket createIdPacket(Object id, Object routing, int version, ITypeDesc typeDesc, QueryResultTypeInternal resultType, AbstractProjectionTemplate projectionTemplate) {
        return new IdQueryPacket(id, routing, version, typeDesc, resultType, projectionTemplate);
    }

    public static AbstractIdsQueryPacket createIdsPacket(Object[] ids, Object routing, ITypeDesc typeDesc, QueryResultTypeInternal resultType, AbstractProjectionTemplate projectionTemplate) {
        return new IdsQueryPacket(ids, routing, typeDesc, resultType, projectionTemplate);
    }

    public static AbstractIdsQueryPacket createIdsPacket(Object[] ids, Object[] routings, ITypeDesc typeDesc, QueryResultTypeInternal resultType, AbstractProjectionTemplate projectionTemplate) {
        return new IdsMultiRoutingQueryPacket(ids, routings, 0, typeDesc, resultType, projectionTemplate);
    }

    public static ITemplatePacket createUidPacket(String uid, int version, boolean returnOnlyUids) {
        return new UidQueryPacket(null, uid, null, version, QueryResultTypeInternal.EXTERNAL_ENTRY, returnOnlyUids, null);
    }

    public static ITemplatePacket createUidPacket(ITypeDesc typeDesc, String uid, Object routing, int version, QueryResultTypeInternal resultType, AbstractProjectionTemplate projectionTemplate) {
        return new UidQueryPacket(typeDesc, uid, routing, version, resultType, false, projectionTemplate);
    }

    public static ITemplatePacket createUidPacket(String uid, Object routing, int version, QueryResultTypeInternal resultType) {
        return new UidQueryPacket(uid, routing, version, resultType);
    }

    public static ITemplatePacket createUidPacket(String uid, int version) {
        return new UidQueryPacket(null, uid, null, version, QueryResultTypeInternal.NOT_SET, false, null);
    }

    public static ITemplatePacket createUidResponsePacket(String uid, int version) {
        return new UidQueryPacket(null, uid, null, version, QueryResultTypeInternal.NOT_SET, true, null);
    }

    public static ITemplatePacket createUidsPacket(String[] uids, QueryResultTypeInternal resultType, boolean returnOnlyUids) {
        return new UidQueryPacket(uids, 0, resultType, returnOnlyUids);
    }

    public static ITemplatePacket createUidsResponsePacket(String[] uids) {
        return new UidQueryPacket(uids, 0, QueryResultTypeInternal.NOT_SET, true);
    }

    public static ITemplatePacket createIdOrUidPacket(ITypeDesc typeDesc, QueryResultTypeInternal resultType, Object routing, Object id, int version, AbstractProjectionTemplate projectionTemplate) {
        if (typeDesc.getIdPropertyName() == null || typeDesc.isAutoGenerateId()) {
            if (!(id instanceof String)) {
                throw new IllegalArgumentException("id must be a String if no SpaceID or SpaceID with AutoGenerate set to true.");
            }
            String uid = (String)id;
            if (typeDesc.isAutoGenerateRouting()) {
                routing = SpaceUidFactory.extractPartitionId(uid);
            }
            return TemplatePacketFactory.createUidPacket(typeDesc, uid, routing, version, resultType, projectionTemplate);
        }
        return TemplatePacketFactory.createIdPacket(id, routing, version, typeDesc, resultType, projectionTemplate);
    }

    public static <T> ITemplatePacket createFromObject(T entry, ITypeDesc typeDesc, EntryType entryType) {
        ITypeIntrospector introspector = typeDesc.getIntrospector(entryType);
        Map<String, Object> dynamicProperties = introspector.getDynamicProperties(entry);
        if (!typeDesc.supportsDynamicProperties() && dynamicProperties != null && !dynamicProperties.isEmpty()) {
            String propertyName = (String)dynamicProperties.keySet().toArray()[0];
            String message = "Cannot access dynamic property '" + propertyName + "' in type '" + typeDesc.getTypeName() + "' - this type does not support dynamic properties.";
            if (typeDesc.getTypeName().equals(Object.class.getName())) {
                message = message + " If you're using SpaceDocument make sure the type name was properly set.";
            }
            throw new SpaceMetadataException(message);
        }
        if (entryType.isConcrete() && typeDesc.isExternalizable()) {
            PropertiesQuery customQuery = dynamicProperties == null ? null : new PropertiesQuery(dynamicProperties, typeDesc);
            return new ExternalizableTemplatePacket(typeDesc, entryType, (Externalizable)entry, customQuery);
        }
        Object[] fixedProperties = introspector.getSerializedValues(entry);
        String uid = introspector.getUID(entry, true, true);
        if (entryType == EntryType.EXTERNAL_ENTRY && uid == null) {
            uid = ExternalEntryIntrospector.getUid(typeDesc, fixedProperties);
        }
        int version = introspector.getVersion(entry);
        long timeToLive = introspector.getTimeToLive(entry);
        boolean isTransient = introspector.isTransient(entry);
        switch (entryType) {
            case OBJECT_JAVA: 
            case DOCUMENT_JAVA: {
                PropertiesQuery customQuery = dynamicProperties == null ? null : new PropertiesQuery(dynamicProperties, typeDesc);
                return new TemplatePacket(typeDesc, entryType, fixedProperties, customQuery, uid, version, timeToLive, isTransient);
            }
            case EXTERNAL_ENTRY: {
                return new ExternalTemplatePacket(typeDesc, entryType, fixedProperties, uid, version, timeToLive, isTransient, (ExternalEntry)entry);
            }
        }
        throw new IllegalArgumentException("Unsupported entry type: " + (Object)((Object)entryType));
    }

    public static ITemplatePacket createFullPacket(IEntryHolder entryHolder, OperationID operationID) {
        long timeToLive = entryHolder.getEntryData().getTimeToLive(true);
        IEntryData entryData = entryHolder.getEntryData();
        return TemplatePacketFactory.createFullPacket(entryHolder, entryData, entryData.getFixedPropertiesValues(), entryHolder.getUID(), timeToLive, operationID);
    }

    public static ITemplatePacket createFullPacket(ITemplateHolder template, String uid, long timeToLive, OperationID operationId) {
        return TemplatePacketFactory.createFullPacket(template, template, uid, timeToLive, operationId);
    }

    public static ITemplatePacket createFullPacket(IEntryHolder entryHolder, ITemplateHolder template, String uid, long timeToLive, OperationID operationId) {
        IEntryData entryData = entryHolder.getEntryData();
        return TemplatePacketFactory.createFullPacket(entryHolder, entryData, entryData.getFixedPropertiesValues(), uid, timeToLive, operationId);
    }

    public static ITemplatePacket createFullPacket(IEntryHolder entryHolder, ITemplateHolder template, String uid, long timeToLive, IEntryData entryData, OperationID operationID) {
        return TemplatePacketFactory.createFullPacket(entryHolder, entryData, entryData.getFixedPropertiesValues(), uid, timeToLive, operationID);
    }

    public static ITemplatePacket createFullPacketForReplication(NotifyTemplateHolder template, OperationID operationID) {
        IEntryData entryData = template.getEntryData();
        long timeToLive = entryData.getTimeToLive(true);
        ITemplatePacket generationTemplate = template.getGenerationTemplate().clone();
        if (generationTemplate instanceof EmptyQueryPacket) {
            generationTemplate = TemplatePacketFactory.createFullPacket((IEntryHolder)template, entryData, entryData.getFixedPropertiesValues(), template.getUidToOperateBy(), timeToLive, operationID);
        }
        generationTemplate.setTTL(timeToLive);
        return generationTemplate;
    }

    private static ITemplatePacket createFullPacket(IEntryHolder entryHolder, IEntryData entryData, Object[] fixedProperties, String uid, long timeToLive, OperationID operationId) {
        ITemplatePacket packet = TemplatePacketFactory.createFullPacket(entryData.getEntryTypeDesc().getTypeDesc(), fixedProperties, entryData.getDynamicProperties(), uid, entryData.getVersion(), timeToLive, entryHolder.isTransient(), entryData.getEntryTypeDesc().getEntryType());
        packet.setOperationID(operationId);
        return packet;
    }

    public static ITemplatePacket createFullPacket(IEntryData entryData, String uid, OperationID operationId, boolean isTransient) {
        ITemplatePacket packet = TemplatePacketFactory.createFullPacket(entryData.getEntryTypeDesc().getTypeDesc(), entryData.getFixedPropertiesValues(), entryData.getDynamicProperties(), uid, entryData.getVersion(), entryData.getTimeToLive(true), isTransient, entryData.getEntryTypeDesc().getEntryType());
        packet.setOperationID(operationId);
        return packet;
    }

    public static ITemplatePacket createFullPacket(IEntryPacket entryPacket) {
        ITemplatePacket templatePacket = TemplatePacketFactory.createFullPacket(entryPacket.getTypeDescriptor(), entryPacket.getFieldValues(), entryPacket.getDynamicProperties(), entryPacket.getUID(), entryPacket.getVersion(), entryPacket.getTTL(), entryPacket.isTransient(), entryPacket.getEntryType());
        templatePacket.setOperationID(entryPacket.getOperationID());
        return templatePacket;
    }

    public static ITemplatePacket createFullPacket(IEntryPacket entryPacket, ITypeDesc typeDesc, boolean isTransient) {
        return TemplatePacketFactory.createFullPacket(typeDesc, entryPacket.getFieldValues(), entryPacket.getDynamicProperties(), null, 0, 0L, isTransient, entryPacket.getEntryType());
    }

    private static ITemplatePacket createFullPacket(ITypeDesc typeDesc, Object[] fixedProperties, Map<String, Object> dynamicProperties, String uid, int version, long timeToLive, boolean isTransient, EntryType entryType) {
        if (entryType == null) {
            entryType = typeDesc.getObjectType();
        }
        switch (entryType) {
            case OBJECT_JAVA: 
            case DOCUMENT_JAVA: 
            case OBJECT_DOTNET: 
            case DOCUMENT_DOTNET: 
            case CPP: {
                PropertiesQuery customQuery;
                PropertiesQuery propertiesQuery = customQuery = dynamicProperties == null ? null : new PropertiesQuery(dynamicProperties, typeDesc);
                if (typeDesc.isExternalizable() && entryType.isConcrete()) {
                    return new ExternalizableTemplatePacket(typeDesc, entryType, fixedProperties, customQuery, uid, version, timeToLive, isTransient);
                }
                return new TemplatePacket(typeDesc, entryType, fixedProperties, customQuery, uid, version, timeToLive, isTransient);
            }
            case EXTERNAL_ENTRY: {
                return new ExternalTemplatePacket(typeDesc, entryType, fixedProperties, uid, version, timeToLive, isTransient, null);
            }
        }
        throw new IllegalArgumentException("Unsupported packet type: " + (Object)((Object)entryType));
    }
}

