/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import java.io.FileWriter;
import java.io.IOException;
import java.util.UUID;

public abstract class AbstractShutdownHook
extends GSThread {
    private static final String LogShutdownHookPath = System.getProperty("com.gigaspaces.shutdownhook.logpath");
    private static final int ShutdownHookTimeout = Integer.getInteger("com.gigaspaces.shutdownhook.timeout", 30);

    public AbstractShutdownHook(String name) {
        super(name);
    }

    public void run() {
        FileWriter fileWriter = this.createFileWriter(LogShutdownHookPath);
        if (fileWriter == null) {
            this.onShutdown();
        } else {
            this.onShutdown(fileWriter);
        }
    }

    protected abstract void onShutdown();

    protected void onShutdownTimeout(FileWriter fileWriter, long duration) {
        this.log(fileWriter, "Timed out (duration=" + duration + "ms).");
    }

    private void onShutdown(FileWriter fileWriter) {
        long time = System.currentTimeMillis();
        this.log(fileWriter, "Starting...");
        GSThread shutdownThread = new GSThread(new Runnable(){

            @Override
            public void run() {
                AbstractShutdownHook.this.onShutdown();
            }
        }, super.getName() + "-async");
        shutdownThread.start();
        for (int i = 0; i < ShutdownHookTimeout; ++i) {
            try {
                shutdownThread.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if (!shutdownThread.isAlive()) break;
            this.log(fileWriter, "Waiting for shutdown hook to complete (iteration #" + i + ")...");
        }
        time = System.currentTimeMillis() - time;
        if (shutdownThread.isAlive()) {
            this.onShutdownTimeout(fileWriter, time);
        } else {
            this.log(fileWriter, "Finished (duration=" + time + "ms).");
        }
        AbstractShutdownHook.closeFileWriter(fileWriter);
    }

    private FileWriter createFileWriter(String path) {
        if (!StringUtils.hasText(path)) {
            return null;
        }
        path = path + "/" + this.getName() + "_" + UUID.randomUUID() + ".log";
        try {
            return new FileWriter(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void log(FileWriter fileWriter, String message) {
        if (fileWriter == null) {
            return;
        }
        message = StringUtils.getTimeStamp() + " [" + this.getName() + "] - " + message + StringUtils.NEW_LINE;
        try {
            fileWriter.write(message);
            fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void closeFileWriter(FileWriter fileWriter) {
        try {
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

