/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.BloomCalculations;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

@InternalApi
public class BloomFilter {
    private static final int EXCESS = 20;
    private BitSet filter_;
    int hashCount;
    private static MurmurHash hasher = new MurmurHash();

    int getHashCount() {
        return this.hashCount;
    }

    public int[] getHashBuckets(String key) {
        return BloomFilter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    public int[] getHashBuckets(byte[] key) {
        return BloomFilter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    static int[] getHashBuckets(String key, int hashCount, int max) {
        byte[] b;
        try {
            b = key.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return BloomFilter.getHashBuckets(b, hashCount, max);
    }

    static int[] getHashBuckets(byte[] b, int hashCount, int max) {
        int[] result = new int[hashCount];
        int hash1 = hasher.hash(b, b.length, 0);
        int hash2 = hasher.hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }

    BloomFilter(int hashes, BitSet filter) {
        this.hashCount = hashes;
        this.filter_ = filter;
    }

    private static BitSet bucketsFor(long numElements, int bucketsPer) {
        long numBits = numElements * (long)bucketsPer + 20L;
        return new BitSet((int)Math.min(Integer.MAX_VALUE, numBits));
    }

    private static int maxBucketsPerElement(long numElements) {
        double v = 2.147483627E9 / (double)(numElements = Math.max(1L, numElements));
        if (v < 1.0) {
            throw new UnsupportedOperationException("Cannot compute probabilities for " + numElements + " elements.");
        }
        return Math.min(BloomCalculations.probs.length - 1, (int)v);
    }

    public static BloomFilter getFilter(long numElements, int targetBucketsPerElem) {
        int maxBucketsPerElement = Math.max(1, BloomFilter.maxBucketsPerElement(numElements));
        int bucketsPerElement = Math.min(targetBucketsPerElem, maxBucketsPerElement);
        if (bucketsPerElement < targetBucketsPerElem) {
            // empty if block
        }
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement);
        return new BloomFilter(spec.K, BloomFilter.bucketsFor(numElements, spec.bucketsPerElement));
    }

    public static BloomFilter getFilter(long numElements, double maxFalsePosProbability) {
        assert (maxFalsePosProbability <= 1.0) : "Invalid probability";
        int bucketsPerElement = BloomFilter.maxBucketsPerElement(numElements);
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBloomSpec(bucketsPerElement, maxFalsePosProbability);
        return new BloomFilter(spec.K, BloomFilter.bucketsFor(numElements, spec.bucketsPerElement));
    }

    public void clear() {
        this.filter_.clear();
    }

    int buckets() {
        return this.filter_.size();
    }

    BitSet filter() {
        return this.filter_;
    }

    public boolean isPresent(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public boolean isPresent(byte[] key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public void add(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public void add(byte[] key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public String toString() {
        return this.filter_.toString();
    }

    int emptyBuckets() {
        int n = 0;
        for (int i = 0; i < this.buckets(); ++i) {
            if (this.filter_.get(i)) continue;
            ++n;
        }
        return n;
    }

    public static BloomFilter alwaysMatchingBloomFilter() {
        BitSet set = new BitSet(64);
        set.set(0, 64);
        return new BloomFilter(1, set);
    }

    private static class MurmurHash {
        private MurmurHash() {
        }

        public int hash(byte[] data, int length, int seed) {
            int m = 1540483477;
            int r = 24;
            int h = seed ^ length;
            int len_4 = length >> 2;
            for (int i = 0; i < len_4; ++i) {
                int i_4 = i << 2;
                int k = data[i_4 + 3];
                k <<= 8;
                k |= data[i_4 + 2] & 0xFF;
                k <<= 8;
                k |= data[i_4 + 1] & 0xFF;
                k <<= 8;
                k |= data[i_4 + 0] & 0xFF;
                k *= m;
                k ^= k >>> r;
                h *= m;
                h ^= (k *= m);
            }
            int len_m = len_4 << 2;
            int left = length - len_m;
            if (left != 0) {
                if (left >= 3) {
                    h ^= data[length - 3] << 16;
                }
                if (left >= 2) {
                    h ^= data[length - 2] << 8;
                }
                if (left >= 1) {
                    h ^= data[length - 1];
                }
                h *= m;
            }
            h ^= h >>> 13;
            h *= m;
            h ^= h >>> 15;
            return h;
        }
    }
}

