/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

public final class BoundedStringBuilder {
    private final char[] value;
    private int count;

    public BoundedStringBuilder(int size) {
        this.value = new char[size];
    }

    public BoundedStringBuilder append(String str) {
        int len;
        if (str == null) {
            str = "null";
        }
        if ((len = str.length()) == 0) {
            return this;
        }
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public BoundedStringBuilder append(char c) {
        this.value[this.count++] = c;
        return this;
    }

    public BoundedStringBuilder append(char[] str) {
        System.arraycopy(str, 0, this.value, this.count, str.length);
        this.count += str.length;
        return this;
    }

    public void setLength(int length) {
        this.count = length;
    }

    public int length() {
        return this.count;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }
}

