/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ClassLoaderCleaner {
    private static final List<String> JVM_THREAD_GROUP_NAMES = new ArrayList<String>();
    private static final Logger logger;
    private static final boolean clearReferencesStopThreads = false;

    public static void clearReferences(ClassLoader classLoader) {
        Class<?> clazz2;
        ClassLoaderCache.getCache().removeClassLoader(classLoader);
        if (NonActivatableServiceDescriptor.getGlobalPolicy() != null) {
            NonActivatableServiceDescriptor.getGlobalPolicy().setPolicy(classLoader, null);
        }
        ClassLoaderCleaner.clearReferencesJdbc(classLoader);
        ClassLoaderCleaner.clearReferencesThreads(classLoader);
        ClassLoaderCleaner.clearReferencesThreadLocals(classLoader);
        ClassLoaderCleaner.clearReferencesRmiTargets(classLoader);
        ClassLoaderCleaner.clearRmiLoaderHandler(classLoader);
        try {
            clazz2 = classLoader.loadClass("org.apache.commons.logging.LogFactory");
            clazz2.getMethod("release", ClassLoader.class).invoke(null, classLoader);
        }
        catch (Throwable clazz2) {
            // empty catch block
        }
        try {
            clazz2 = classLoader.loadClass("org.apache.juli.logging.LogFactory");
            clazz2.getMethod("release", ClassLoader.class).invoke(null, classLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClassLoaderCleaner.clearReferencesResourceBundles(classLoader);
        Introspector.flushCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearRmiLoaderHandler(ClassLoader classLoader) {
        try {
            Class<?> loaderHandlerClass;
            Class<?> clazz = loaderHandlerClass = classLoader.loadClass("sun.rmi.server.LoaderHandler");
            synchronized (clazz) {
                Field loadTableField = loaderHandlerClass.getDeclaredField("loaderTable");
                loadTableField.setAccessible(true);
                Map loaderTable = (Map)loadTableField.get(null);
                Iterator it = loaderTable.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Object loaderKey = entry.getKey();
                    Field parentField = loaderKey.getClass().getDeclaredField("parent");
                    parentField.setAccessible(true);
                    if (parentField.get(loaderKey) != classLoader) continue;
                    it.remove();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void clearReferencesJdbc(ClassLoader classLoader) {
        InputStream is = classLoader.getResourceAsStream("com/gigaspaces/internal/utils/JdbcLeakPrevention.class");
        byte[] classBytes = new byte[2048];
        int offset = 0;
        try {
            int read = is.read(classBytes, offset, classBytes.length - offset);
            while (read > -1) {
                if ((offset += read) == classBytes.length) {
                    byte[] tmp = new byte[classBytes.length * 2];
                    System.arraycopy(classBytes, 0, tmp, 0, classBytes.length);
                    classBytes = tmp;
                }
                read = is.read(classBytes, offset, classBytes.length - offset);
            }
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
            Class lpClass = (Class)defineClassMethod.invoke((Object)classLoader, "com.gigaspaces.internal.utils.JdbcLeakPrevention", classBytes, 0, offset);
            Object obj = lpClass.newInstance();
            List driverNames = (List)obj.getClass().getMethod("clearJdbcDriverRegistrations", new Class[0]).invoke(obj, new Object[0]);
            for (String name : driverNames) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("A class loader registered the JDBC driver [" + name + "] but failed to unregister it when the web application was stopped. To prevent a memory leak, the JDBC Driver has been forcibly unregistered.");
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "JDBC driver de-registration failed", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void clearReferencesThreads(ClassLoader classLoader) {
        Thread[] threads;
        for (Thread thread : threads = ClassLoaderCleaner.getThreads()) {
            ThreadGroup tg;
            ClassLoader ccl;
            if (thread == null || (ccl = thread.getContextClassLoader()) == null || ccl != classLoader || thread == Thread.currentThread() || !thread.isAlive() || (tg = thread.getThreadGroup()) != null && JVM_THREAD_GROUP_NAMES.contains(tg.getName())) continue;
            if (thread.getClass().getName().equals("java.util.TimerThread")) {
                ClassLoaderCleaner.clearReferencesStopTimerThread(thread);
                continue;
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("A thread named [" + thread.getName() + "] started but has failed to stop it. This is very likely to create a memory leak.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearReferencesStopTimerThread(Thread thread) {
        try {
            Field newTasksMayBeScheduledField = thread.getClass().getDeclaredField("newTasksMayBeScheduled");
            newTasksMayBeScheduledField.setAccessible(true);
            Field queueField = thread.getClass().getDeclaredField("queue");
            queueField.setAccessible(true);
            Object queue = queueField.get(thread);
            Method clearMethod = queue.getClass().getDeclaredMethod("clear", new Class[0]);
            clearMethod.setAccessible(true);
            Object object = queue;
            synchronized (object) {
                newTasksMayBeScheduledField.setBoolean(thread, false);
                clearMethod.invoke(queue, new Object[0]);
                queue.notify();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("A web application appears to have started a TimerThread named [" + thread.getName() + "] via the java.util.Timer API but has failed to stop it. To prevent a memory leak, the timer (and hence the associated thread) has been forcibly cancelled.");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to terminate TimerThread named [" + thread.getName() + "]", e);
        }
    }

    private static void clearReferencesThreadLocals(ClassLoader classLoader) {
        Thread[] threads = ClassLoaderCleaner.getThreads();
        try {
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            inheritableThreadLocalsField.setAccessible(true);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            tableField.setAccessible(true);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i] == null) continue;
                Object threadLocalMap = threadLocalsField.get(threads[i]);
                ClassLoaderCleaner.clearThreadLocalMap(threadLocalMap, tableField, classLoader);
                threadLocalMap = inheritableThreadLocalsField.get(threads[i]);
                ClassLoaderCleaner.clearThreadLocalMap(threadLocalMap, tableField, classLoader);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to clear ThreadLocal references", e);
        }
    }

    private static void clearThreadLocalMap(Object map, Field internalTableField, ClassLoader classLoader) throws NoSuchMethodException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        if (map != null) {
            Method mapRemove = map.getClass().getDeclaredMethod("remove", ThreadLocal.class);
            mapRemove.setAccessible(true);
            Object[] table = (Object[])internalTableField.get(map);
            int staleEntriesCount = 0;
            if (table != null) {
                for (int j = 0; j < table.length; ++j) {
                    Object tableEntry = table[j];
                    if (tableEntry == null) continue;
                    boolean remove = false;
                    Object key = ((Reference)tableEntry).get();
                    if (classLoader.equals(key) || key != null && classLoader == key.getClass().getClassLoader()) {
                        remove = true;
                    }
                    Field valueField = tableEntry.getClass().getDeclaredField("value");
                    valueField.setAccessible(true);
                    Object value = valueField.get(tableEntry);
                    if (classLoader.equals(value) || value != null && classLoader == value.getClass().getClassLoader()) {
                        remove = true;
                    }
                    if (!remove) continue;
                    Object[] args = new Object[4];
                    if (key != null) {
                        args[0] = key.getClass().getCanonicalName();
                        args[1] = key.toString();
                    }
                    if (value != null) {
                        args[2] = value.getClass().getCanonicalName();
                        args[3] = value.toString();
                    }
                    if (value == null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("A created a ThreadLocal with key of type [" + args[0] + "] (value [" + args[1] + "]). The ThreadLocal has been correctly set to null and the key will be removed by GC. However, to simplify the process of tracing memory leaks, the key has been forcibly removed.");
                        }
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.fine("A created ThreadLocal with key of type [" + args[0] + "] (value [" + args[1] + "]) and a value of type [" + args[2] + "] (value [" + args[3] + "]) but failed to remove it when class loader is removed. To prevent a memory leak, the ThreadLocal has been forcibly removed.");
                    }
                    if (key == null) {
                        ++staleEntriesCount;
                        continue;
                    }
                    mapRemove.invoke(map, key);
                }
            }
            if (staleEntriesCount > 0) {
                Method mapRemoveStale = map.getClass().getDeclaredMethod("expungeStaleEntries", new Class[0]);
                mapRemoveStale.setAccessible(true);
                mapRemoveStale.invoke(map, new Object[0]);
            }
        }
    }

    private static Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    private static void clearReferencesRmiTargets(ClassLoader classLoader) {
        try {
            Class<?> objectTargetClass = Class.forName("sun.rmi.transport.Target");
            Field cclField = objectTargetClass.getDeclaredField("ccl");
            cclField.setAccessible(true);
            Class<?> objectTableClass = Class.forName("sun.rmi.transport.ObjectTable");
            Field objTableField = objectTableClass.getDeclaredField("objTable");
            objTableField.setAccessible(true);
            Object objTable = objTableField.get(null);
            if (objTable == null) {
                return;
            }
            if (objTable instanceof Map) {
                Iterator iter = ((Map)objTable).values().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    Object cclObject = cclField.get(obj);
                    if (classLoader != cclObject) continue;
                    iter.remove();
                }
            }
            Field implTableField = objectTableClass.getDeclaredField("implTable");
            implTableField.setAccessible(true);
            Object implTable = implTableField.get(null);
            if (implTable == null) {
                return;
            }
            if (implTable instanceof Map) {
                Iterator iter = ((Map)implTable).values().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    Object cclObject = cclField.get(obj);
                    if (classLoader != cclObject) continue;
                    iter.remove();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to clear context class loader referenced from sun.rmi.transport.Target ", e);
        }
    }

    private static void clearReferencesResourceBundles(ClassLoader classLoader) {
        try {
            Field cacheListField = ResourceBundle.class.getDeclaredField("cacheList");
            cacheListField.setAccessible(true);
            Map cacheList = (Map)cacheListField.get(null);
            Set keys = cacheList.keySet();
            HashSet<Field> fieldsRef = new HashSet<Field>();
            Iterator keysIter = keys.iterator();
            int countRemoved = 0;
            block2: while (keysIter.hasNext()) {
                Object key = keysIter.next();
                if (fieldsRef.isEmpty()) {
                    for (Field f : key.getClass().getDeclaredFields()) {
                        if (f.getName().equals("loaderRef")) {
                            f.setAccessible(true);
                            fieldsRef.add(f);
                            break;
                        }
                        if (!f.getName().equals("callerRef") && !f.getName().equals("moduleRef")) continue;
                        f.setAccessible(true);
                        fieldsRef.add(f);
                    }
                    if (fieldsRef.isEmpty()) {
                        logger.log(Level.WARNING, "Failed to clear ResourceBundle references");
                        return;
                    }
                }
                for (Field fieldRef : fieldsRef) {
                    ClassLoader loader = null;
                    WeakReference weakRef = (WeakReference)fieldRef.get(key);
                    Object refVal = weakRef.get();
                    if (refVal == null) continue;
                    if (refVal instanceof ClassLoader) {
                        loader = (ClassLoader)refVal;
                    } else if (refVal.getClass().getName().equals("java.lang.Module")) {
                        Method method = refVal.getClass().getMethod("getClassLoader", new Class[0]);
                        loader = (ClassLoader)method.invoke(refVal, new Object[0]);
                    }
                    while (loader != null && loader != classLoader) {
                        loader = loader.getParent();
                    }
                    if (loader == null) continue;
                    keysIter.remove();
                    ++countRemoved;
                    continue block2;
                }
            }
            if (countRemoved > 0 && logger.isLoggable(Level.FINE)) {
                logger.fine("Removed [" + countRemoved + "] ResourceBundle references from the cache");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to clear ResourceBundle references", e);
        }
    }

    static {
        JVM_THREAD_GROUP_NAMES.add("system");
        JVM_THREAD_GROUP_NAMES.add("RMI Runtime");
        logger = Logger.getLogger("com.gigaspaces.core.classloadercleaner");
    }
}

