/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;

@InternalApi
public class ClassLoaderThreadLocal<T>
implements IClassLoaderCacheStateListener {
    private final CopyOnUpdateMap<Long, ThreadLocal<T>> _classLoaderThreadLocalMap = new CopyOnUpdateMap();

    public ClassLoaderThreadLocal() {
        ClassLoaderCache.getCache().registerCacheStateListener(this);
    }

    protected T initialValue() {
        return null;
    }

    public T get() {
        ThreadLocal<T> threadLocal = this.getContextClassLoaderThreadLocal();
        return threadLocal.get();
    }

    public void set(T value) {
        ThreadLocal<T> threadLocal = this.getContextClassLoaderThreadLocal();
        threadLocal.set(value);
    }

    private ThreadLocal<T> getContextClassLoaderThreadLocal() {
        ThreadLocal temp;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Long classLoaderKey = classLoader != null ? ClassLoaderCache.getCache().putClassLoader(classLoader) : -1L;
        ThreadLocal threadLocal = this._classLoaderThreadLocalMap.get(classLoaderKey);
        if (threadLocal == null && (threadLocal = (ThreadLocal)this._classLoaderThreadLocalMap.putIfAbsent(classLoaderKey, temp = new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                return ClassLoaderThreadLocal.this.initialValue();
            }
        })) == null) {
            threadLocal = temp;
        }
        return threadLocal;
    }

    @Override
    public void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
        this._classLoaderThreadLocalMap.remove(classLoaderKey);
    }
}

