/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.classloader.CustomURLClassLoader;
import com.gigaspaces.internal.utils.StringUtils;
import java.net.URL;
import java.net.URLClassLoader;
import org.jini.rio.boot.LoggableClassLoader;

@InternalApi
public class ClassLoaderUtils {
    public static String getCurrentClassPathString(String prefix) {
        return ClassLoaderUtils.getClassPathString(Thread.currentThread().getContextClassLoader(), prefix);
    }

    public static String getClassPathString(ClassLoader classLoader, String prefix) {
        StringBuilder classpath = new StringBuilder();
        ClassLoaderUtils.appendClassLoader(classLoader, classpath, prefix);
        return classpath.toString();
    }

    private static void appendClassLoader(ClassLoader classLoader, StringBuilder classpath, String prefix) {
        if (classLoader == null) {
            return;
        }
        classpath.append(prefix + ": " + ClassLoaderUtils.getClassLoaderName(classLoader));
        if (classLoader instanceof URLClassLoader) {
            URL[] urls = classLoader instanceof CustomURLClassLoader ? ((CustomURLClassLoader)classLoader).getSearchPath() : ((URLClassLoader)classLoader).getURLs();
            classpath.append(", Urls: " + urls.length + StringUtils.NEW_LINE);
            for (URL url : urls) {
                classpath.append("    " + url + StringUtils.NEW_LINE);
            }
        }
        if (classLoader != ClassLoader.getSystemClassLoader()) {
            ClassLoaderUtils.appendClassLoader(classLoader.getParent(), classpath, "Parent Class Loader");
        }
    }

    private static String getClassLoaderName(ClassLoader classLoader) {
        if (classLoader instanceof LoggableClassLoader) {
            return ((LoggableClassLoader)classLoader).getLogName();
        }
        if (ClassLoader.getSystemClassLoader().equals(classLoader)) {
            return "System class Loader";
        }
        return classLoader.toString();
    }

    public static boolean isClassLoaderProblem(Throwable t) {
        boolean classLoaderProblem = false;
        while (!classLoaderProblem && t != null) {
            if (t instanceof NoClassDefFoundError) {
                classLoaderProblem = true;
            }
            t = t.getCause();
        }
        return classLoaderProblem;
    }

    public static boolean isUnderClassLoader(Class<?> type, Class<?> classLoaderType) {
        for (ClassLoader classLoader = type.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            if (!classLoaderType.isAssignableFrom(classLoader.getClass())) continue;
            return true;
        }
        return false;
    }
}

