/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.internal.utils.StringUtils;
import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final char PACKAGE_SEPARATOR_CHAR = '.';
    private static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final String CGLIB_CLASS_SEPARATOR_CHAR = "$$";
    private static final Map<Class, Class> primitiveWrapperTypeMap = new HashMap<Class, Class>(8);
    private static final Map<String, Class> primitiveTypeNameMap = new HashMap<String, Class>(8);

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl;
    }

    public static boolean isPresent(String className) {
        try {
            ClassUtils.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class forName(String name) throws ClassNotFoundException {
        return ClassUtils.forName(name, ClassUtils.getDefaultClassLoader());
    }

    public static Class forName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        return Class.forName(name, true, classLoader);
    }

    public static Class resolvePrimitiveClassName(String name) {
        Class result = null;
        if (name != null && name.length() <= 8) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    public static String getShortName(String className) {
        if (!StringUtils.hasLength(className)) {
            throw new IllegalArgumentException("Class name must not be empty");
        }
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR_CHAR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        return shortName.replace('$', '.');
    }

    public static String getShortName(Class clazz) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class clazz) {
        return Introspector.decapitalize(ClassUtils.getShortName(clazz));
    }

    public static String getQualifiedName(Class clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        if (clazz.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz);
        }
        return clazz.getName();
    }

    public static String getQualifiedMethodName(Method method) {
        Objects.requireNonNull(method, "Method must not be null");
        return method.getDeclaringClass().getName() + '.' + method.getName();
    }

    public static boolean hasMethod(Class clazz, String methodName, Class[] paramTypes) {
        return ClassUtils.getMethodIfAvailable(clazz, methodName, paramTypes) != null;
    }

    public static Method getMethodIfAvailable(Class clazz, String methodName, Class[] paramTypes) {
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(methodName, "Method name must not be null");
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static int getMethodCountForName(Class clazz, String methodName) {
        Class<?>[] ifcs;
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(methodName, "Method name must not be null");
        int count = 0;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            ++count;
        }
        for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
            count += ClassUtils.getMethodCountForName(ifc, methodName);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            count += ClassUtils.getMethodCountForName(superClass, methodName);
        }
        return count;
    }

    public static boolean hasAtLeastOneMethodWithName(Class clazz, String methodName) {
        Class<?>[] ifcs;
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(methodName, "Method name must not be null");
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return true;
        }
        for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
            if (!ClassUtils.hasAtLeastOneMethodWithName(ifc, methodName)) continue;
            return true;
        }
        Class superClass = clazz.getSuperclass();
        return superClass != null && ClassUtils.hasAtLeastOneMethodWithName(superClass, methodName);
    }

    public static Method getStaticMethod(Class clazz, String methodName, Class[] args) {
        Objects.requireNonNull(clazz, "Class must not be null");
        Objects.requireNonNull(methodName, "Method name must not be null");
        try {
            Method method = clazz.getDeclaredMethod(methodName, args);
            if ((method.getModifiers() & 8) != 0) {
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveOrWrapper(Class clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class clazz) {
        Objects.requireNonNull(clazz, "Class must not be null");
        return clazz.isArray() && ClassUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static boolean isAssignable(Class targetType, Class valueType) {
        Objects.requireNonNull(targetType, "Target type must not be null");
        Objects.requireNonNull(valueType, "Value type must not be null");
        return targetType.isAssignableFrom(valueType) || targetType.equals(primitiveWrapperTypeMap.get(valueType));
    }

    public static boolean isAssignableValue(Class type, Object value) {
        Objects.requireNonNull(type, "Type must not be null");
        return value != null ? ClassUtils.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    public static String addResourcePathToPackagePath(Class clazz, String resourceName) {
        Objects.requireNonNull(resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz) + '/' + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classPackageAsResourcePath(Class clazz) {
        if (clazz == null || clazz.getPackage() == null) {
            return "";
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    public static Class[] getAllInterfaces(Object object) {
        Set<Class> interfaces = ClassUtils.getAllInterfacesAsSet(object);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Class[] getAllInterfacesForClass(Class clazz) {
        Set<Class> interfaces = ClassUtils.getAllInterfacesForClassAsSet(clazz);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Set<Class> getAllInterfacesAsSet(Object object) {
        return ClassUtils.getAllInterfacesForClassAsSet(object.getClass());
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        HashSet<Class> interfaces = new HashSet<Class>();
        while (clazz != null) {
            for (int i = 0; i < clazz.getInterfaces().length; ++i) {
                Class<?> ifc = clazz.getInterfaces()[i];
                interfaces.add(ifc);
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    private static String getQualifiedNameForArray(Class clazz) {
        StringBuilder buffer = new StringBuilder();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            buffer.append(ARRAY_SUFFIX);
        }
        buffer.insert(0, clazz.getName());
        return buffer.toString();
    }

    public static Class getClass(Object obj) {
        if (obj != null) {
            return obj.getClass();
        }
        return null;
    }

    public static String getPackage(String className) {
        int inx = className.lastIndexOf(".");
        return inx == -1 ? "" : className.substring(0, inx);
    }

    public static String getTypeDisplayName(String typeName) {
        if (typeName == null || typeName.length() == 0) {
            return typeName;
        }
        if (typeName.charAt(0) != '[') {
            return typeName;
        }
        if (typeName.equals("[B")) {
            return Byte.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.equals("[S")) {
            return Short.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.equals("[I")) {
            return Integer.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.equals("[J")) {
            return Long.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.equals("[F")) {
            return Float.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.equals("[D")) {
            return Double.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.equals("[Z")) {
            return Boolean.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.equals("[C")) {
            return Character.TYPE.getName() + ARRAY_SUFFIX;
        }
        if (typeName.startsWith("[L") && typeName.endsWith(";")) {
            return ClassUtils.getTypeDisplayName(typeName.substring(2, typeName.length() - 1) + ARRAY_SUFFIX);
        }
        return ClassUtils.getTypeDisplayName(typeName.substring(1, typeName.length())) + ARRAY_SUFFIX;
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        for (Class primitiveClass : primitiveWrapperTypeMap.values()) {
            primitiveTypeNameMap.put(primitiveClass.getName(), primitiveClass);
        }
    }
}

