/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfoRepository;
import com.gigaspaces.internal.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public abstract class CollectionUtils {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean contains(Iterator<T> iterator, T element) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                T candidate = iterator.next();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean contains(Enumeration<T> enumeration, T element) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                T candidate = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(candidate, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean hasUniqueObject(Collection<T> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean hasCandidate = false;
        Object candidate = null;
        for (T elem : collection) {
            if (!hasCandidate) {
                hasCandidate = true;
                candidate = elem;
                continue;
            }
            if (candidate == elem) continue;
            return false;
        }
        return true;
    }

    public static <T> T findValueOfType(Collection<T> collection, Class<? extends T> type) throws IllegalArgumentException {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<Object> typeToUse = type != null ? type : Object.class;
        T value = null;
        for (T obj : collection) {
            if (!typeToUse.isInstance(obj)) continue;
            if (value != null) {
                throw new IllegalArgumentException("More than one value of type [" + typeToUse.getName() + "] found");
            }
            value = obj;
        }
        return value;
    }

    public static <T> T findValueOfType(Collection<T> collection, Class<? extends T>[] types) {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(types)) {
            return null;
        }
        for (Class<? extends T> type : types) {
            T value = CollectionUtils.findValueOfType(collection, type);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static <T> List<T> toList(T ... items) {
        if (items == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(items.length);
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <T> List<T> toUnmodifiableList(T ... items) {
        List<T> result = CollectionUtils.toList(items);
        return result == null ? null : Collections.unmodifiableList(result);
    }

    public static <T> Set<T> toSet(T ... items) {
        if (items == null) {
            return null;
        }
        HashSet<T> set = new HashSet<T>(items.length);
        for (T item : items) {
            set.add(item);
        }
        return set;
    }

    public static <T> Set<T> toUnmodifiableSet(T ... items) {
        Set<T> result = CollectionUtils.toSet(items);
        return result == null ? null : Collections.unmodifiableSet(result);
    }

    public static void mergePropertiesIntoMap(Properties props, Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (props != null) {
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                map.put(key, props.getProperty(key));
            }
        }
    }

    public static <T> boolean containsAny(Collection<T> source, Collection<T> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return false;
        }
        for (T candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return true;
        }
        return false;
    }

    public static <T> T findFirstMatch(Collection<T> source, Collection<T> candidates) {
        if (CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(candidates)) {
            return null;
        }
        for (T candidate : candidates) {
            if (!source.contains(candidate)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> boolean equals(Collection<T> c1, Collection<T> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        Iterator<T> i1 = c1.iterator();
        Iterator<T> i2 = c2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            T o2;
            T o1 = i1.next();
            if (ObjectUtils.equals(o1, o2 = i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public static <T> List<T> cloneList(List<T> list) {
        if (list instanceof ArrayList) {
            return (List)((ArrayList)list).clone();
        }
        if (list instanceof LinkedList) {
            return (List)((LinkedList)list).clone();
        }
        if (list.getClass().getName().equals("java.util.Arrays$ArrayList")) {
            return new ArrayList<T>(list);
        }
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(list.getClass());
        List result = (List)typeInfo.createInstance();
        result.addAll(list);
        return result;
    }

    public static <T> Collection<T> cloneCollection(Collection<T> collection) {
        if (collection instanceof List) {
            return CollectionUtils.cloneList((List)collection);
        }
        if (collection instanceof HashSet) {
            return (Collection)((HashSet)collection).clone();
        }
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(collection.getClass());
        Collection result = (Collection)typeInfo.createInstance();
        result.addAll(collection);
        return result;
    }

    public static <K, V> Map<K, V> cloneMap(Map<K, V> map) {
        if (map instanceof HashMap) {
            return (Map)((HashMap)map).clone();
        }
        if (map instanceof TreeMap) {
            return (Map)((TreeMap)map).clone();
        }
        SpaceTypeInfo typeInfo = SpaceTypeInfoRepository.getTypeInfo(map.getClass());
        Map result = (Map)typeInfo.createInstance();
        result.putAll(map);
        return result;
    }

    public static <T> T first(Collection<T> collection) {
        Iterator<T> iterator = collection.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }
}

