/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.time.SystemTime;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ConditionLatch {
    private static final String DEFAULT_TIMEOUT_ERROR_MESSAGE = "Operation timed out";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private String timeoutErrorMessage = "Operation timed out";
    private long pollingIntervalMilliseconds = 50L;
    private long timeoutMilliseconds;

    public ConditionLatch timeoutErrorMessage(String timeoutErrorMessage) {
        this.timeoutErrorMessage = timeoutErrorMessage;
        return this;
    }

    public ConditionLatch pollingInterval(long duration, TimeUnit timeunit) {
        this.pollingIntervalMilliseconds = timeunit.toMillis(duration);
        return this;
    }

    public ConditionLatch timeout(long timeout, TimeUnit timeunit) {
        this.timeoutMilliseconds = timeunit.toMillis(timeout);
        return this;
    }

    public void waitFor(Predicate predicate) throws InterruptedException, TimeoutException {
        long end = SystemTime.timeMillis() + this.timeoutMilliseconds;
        boolean isDone = predicate.isDone();
        while (!isDone && SystemTime.timeMillis() < end) {
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "next check in " + this.pollingIntervalMilliseconds + " milliseconds");
            }
            Thread.sleep(this.pollingIntervalMilliseconds);
            isDone = predicate.isDone();
        }
        if (!isDone && SystemTime.timeMillis() >= end) {
            throw new TimeoutException(this.timeoutErrorMessage);
        }
    }

    public static interface Predicate {
        public boolean isDone() throws InterruptedException;
    }
}

