/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class NativeLibraryLoader {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.common");
    private static final Set<String> _loadedLibs = new HashSet<String>();
    private static final String _defaultNativeLibPath = SystemInfo.singleton().locations().lib() + File.separator + "platform" + File.separator + "native";

    public static void loadNativeLibrary(String libraryName) {
        NativeLibraryLoader.loadNativeLibrary(libraryName, null);
    }

    public static synchronized void loadNativeLibrary(String libraryName, String customProperty) {
        if (_loadedLibs.contains(libraryName)) {
            return;
        }
        String path = null;
        if (customProperty != null) {
            path = System.getProperty(customProperty);
        }
        if (path == null) {
            path = _defaultNativeLibPath + File.separator + libraryName + ".dll";
        }
        if (_logger != null && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Loading " + libraryName + " library from " + path);
        }
        System.load(path);
        _loadedLibs.add(libraryName);
    }
}

