/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.internal.utils.parsers.AbstractParser;
import com.gigaspaces.internal.utils.parsers.BigDecimalParser;
import com.gigaspaces.internal.utils.parsers.BlobParser;
import com.gigaspaces.internal.utils.parsers.BooleanParser;
import com.gigaspaces.internal.utils.parsers.ByteParser;
import com.gigaspaces.internal.utils.parsers.CharacterParser;
import com.gigaspaces.internal.utils.parsers.ClobParser;
import com.gigaspaces.internal.utils.parsers.ConventionObjectParser;
import com.gigaspaces.internal.utils.parsers.DateParser;
import com.gigaspaces.internal.utils.parsers.DoubleParser;
import com.gigaspaces.internal.utils.parsers.EnumParser;
import com.gigaspaces.internal.utils.parsers.FloatParser;
import com.gigaspaces.internal.utils.parsers.IntegerParser;
import com.gigaspaces.internal.utils.parsers.LocalDateParser;
import com.gigaspaces.internal.utils.parsers.LocalDateTimeParser;
import com.gigaspaces.internal.utils.parsers.LocalTimeParser;
import com.gigaspaces.internal.utils.parsers.LongParser;
import com.gigaspaces.internal.utils.parsers.ShortParser;
import com.gigaspaces.internal.utils.parsers.SqlDateParser;
import com.gigaspaces.internal.utils.parsers.SqlTimeParser;
import com.gigaspaces.internal.utils.parsers.SqlTimestampParser;
import com.gigaspaces.internal.utils.parsers.StringParser;
import com.j_spaces.jdbc.driver.Blob;
import com.j_spaces.jdbc.driver.Clob;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public abstract class ObjectConverter {
    private static final Map<String, AbstractParser> _typeParserMap = ObjectConverter.createTypeConverterMap();
    private static final Map<String, AbstractParser> _runtimeGeneratedParserMap = new ConcurrentHashMap<String, AbstractParser>();

    public static Object convert(Object obj, Class<?> type) throws SQLException {
        if (obj == null) {
            return null;
        }
        if (type.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (type.equals(Object.class)) {
            return obj;
        }
        AbstractParser parser = ObjectConverter.getParserFromType(type);
        if (parser == null) {
            throw new SQLException("Failed converting [" + obj + "] from '" + obj.getClass().getName() + "' to '" + type.getName() + "' - converter not found.");
        }
        try {
            obj = parser.parse(obj.toString());
            return obj;
        }
        catch (RuntimeException e) {
            SQLException ex = new SQLException("Failed converting [" + obj + "] from '" + obj.getClass().getName() + "' to '" + type.getName() + "'.");
            ex.initCause(e);
            throw ex;
        }
    }

    private static AbstractParser getParserFromType(Class<?> type) {
        AbstractParser parser = _typeParserMap.get(type.getName());
        if (parser == null) {
            parser = _runtimeGeneratedParserMap.get(type.getName());
        }
        if (parser == null) {
            if (type.isEnum()) {
                parser = new EnumParser(type);
                _runtimeGeneratedParserMap.put(type.getName(), parser);
                return parser;
            }
            if (type.getEnclosingClass() != null && type.getEnclosingClass().isEnum()) {
                parser = _runtimeGeneratedParserMap.get(type.getEnclosingClass().getName());
                if (parser == null) {
                    parser = new EnumParser(type.getEnclosingClass());
                    _runtimeGeneratedParserMap.put(type.getEnclosingClass().getName(), parser);
                }
                return parser;
            }
            if (java.util.Date.class.isAssignableFrom(type) || Temporal.class.isAssignableFrom(type)) {
                ObjectConverter.initDateRelatedTypes();
                parser = _runtimeGeneratedParserMap.get(type.getName());
                if (parser != null) {
                    return parser;
                }
            }
            if ((parser = ConventionObjectParser.getConventionParserIfAvailable(type)) != null) {
                _runtimeGeneratedParserMap.put(type.getName(), parser);
                return parser;
            }
        }
        return parser;
    }

    private static Map<String, AbstractParser> createTypeConverterMap() {
        ConcurrentHashMap<String, AbstractParser> map = new ConcurrentHashMap<String, AbstractParser>();
        map.put(Byte.class.getName(), new ByteParser());
        map.put(Short.class.getName(), new ShortParser());
        map.put(Integer.class.getName(), new IntegerParser());
        map.put(Long.class.getName(), new LongParser());
        map.put(Float.class.getName(), new FloatParser());
        map.put(Double.class.getName(), new DoubleParser());
        map.put(Boolean.class.getName(), new BooleanParser());
        map.put(Character.class.getName(), new CharacterParser());
        map.put(Byte.TYPE.getName(), (AbstractParser)map.get(Byte.class.getName()));
        map.put(Short.TYPE.getName(), (AbstractParser)map.get(Short.class.getName()));
        map.put(Integer.TYPE.getName(), (AbstractParser)map.get(Integer.class.getName()));
        map.put(Long.TYPE.getName(), (AbstractParser)map.get(Long.class.getName()));
        map.put(Float.TYPE.getName(), (AbstractParser)map.get(Float.class.getName()));
        map.put(Double.TYPE.getName(), (AbstractParser)map.get(Double.class.getName()));
        map.put(Boolean.TYPE.getName(), (AbstractParser)map.get(Boolean.class.getName()));
        map.put(Character.TYPE.getName(), (AbstractParser)map.get(Character.class.getName()));
        map.put(String.class.getName(), new StringParser());
        map.put(BigDecimal.class.getName(), new BigDecimalParser());
        map.put(Blob.class.getName(), new BlobParser());
        map.put(Clob.class.getName(), new ClobParser());
        return map;
    }

    private static void initDateRelatedTypes() {
        _runtimeGeneratedParserMap.put(LocalDate.class.getName(), new LocalDateParser());
        _runtimeGeneratedParserMap.put(LocalTime.class.getName(), new LocalTimeParser());
        _runtimeGeneratedParserMap.put(LocalDateTime.class.getName(), new LocalDateTimeParser());
        _runtimeGeneratedParserMap.put(java.util.Date.class.getName(), new DateParser());
        _runtimeGeneratedParserMap.put(Date.class.getName(), new SqlDateParser());
        _runtimeGeneratedParserMap.put(Time.class.getName(), new SqlTimeParser());
        _runtimeGeneratedParserMap.put(Timestamp.class.getName(), new SqlTimestampParser());
    }

    public static void clearRuntimeGeneratedCache() {
        if (!_runtimeGeneratedParserMap.isEmpty()) {
            Logger.getLogger("ObjectConverter").info("clearing runtime generated parser cache");
            _runtimeGeneratedParserMap.clear();
        }
    }
}

