/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class ObjectUtils {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    private static final Map<String, Class<?>> _primitiveTypes = ObjectUtils.initPrimitiveTypes();
    private static final Map<Class<?>, Object> _defaultValues = ObjectUtils.initDefaultValues();

    private static Map<String, Class<?>> initPrimitiveTypes() {
        HashMap result = new HashMap();
        result.put(Byte.TYPE.getName(), Byte.TYPE);
        result.put(Short.TYPE.getName(), Short.TYPE);
        result.put(Integer.TYPE.getName(), Integer.TYPE);
        result.put(Long.TYPE.getName(), Long.TYPE);
        result.put(Float.TYPE.getName(), Float.TYPE);
        result.put(Double.TYPE.getName(), Double.TYPE);
        result.put(Boolean.TYPE.getName(), Boolean.TYPE);
        result.put(Character.TYPE.getName(), Character.TYPE);
        return result;
    }

    private static Map<Class<?>, Object> initDefaultValues() {
        HashMap result = new HashMap();
        result.put(Byte.TYPE, (byte)0);
        result.put(Short.TYPE, (short)0);
        result.put(Integer.TYPE, 0);
        result.put(Long.TYPE, 0L);
        result.put(Float.TYPE, Float.valueOf(0.0f));
        result.put(Double.TYPE, 0.0);
        result.put(Boolean.TYPE, false);
        result.put(Character.TYPE, Character.valueOf('\u0000'));
        return result;
    }

    public static boolean isCheckedException(Throwable ex) {
        return !(ex instanceof RuntimeException) && !(ex instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class<?>[] declaredExceptions) {
        if (!ObjectUtils.isCheckedException(ex)) {
            return true;
        }
        if (declaredExceptions != null) {
            for (Class<?> declaredException : declaredExceptions) {
                if (!declaredException.isAssignableFrom(ex.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] addObjectToArray(T[] array, T obj) {
        Class<Object> compType = array != null ? array.getClass().getComponentType() : (obj != null ? obj.getClass() : Object.class);
        int newArrLength = array != null ? array.length + 1 : 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array != null) {
            System.arraycopy(array, 0, newArr, 0, array.length);
        }
        newArr[newArr.length - 1] = obj;
        return newArr;
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        return false;
    }

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Object[]) {
            return ObjectUtils.nullSafeHashCode((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ObjectUtils.nullSafeHashCode((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ObjectUtils.nullSafeHashCode((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ObjectUtils.nullSafeHashCode((char[])obj);
        }
        if (obj instanceof double[]) {
            return ObjectUtils.nullSafeHashCode((double[])obj);
        }
        if (obj instanceof float[]) {
            return ObjectUtils.nullSafeHashCode((float[])obj);
        }
        if (obj instanceof int[]) {
            return ObjectUtils.nullSafeHashCode((int[])obj);
        }
        if (obj instanceof long[]) {
            return ObjectUtils.nullSafeHashCode((long[])obj);
        }
        if (obj instanceof short[]) {
            return ObjectUtils.nullSafeHashCode((short[])obj);
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.nullSafeHashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int hashCode(boolean bool) {
        return bool ? 1231 : 1237;
    }

    public static int hashCode(double dbl) {
        long bits = Double.doubleToLongBits(dbl);
        return ObjectUtils.hashCode(bits);
    }

    public static int hashCode(float flt) {
        return Float.floatToIntBits(flt);
    }

    public static int hashCode(long lng) {
        return (int)(lng ^ lng >>> 32);
    }

    public static String nullSafeToString(Object obj) {
        if (obj == null) {
            return NULL_STRING;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Object[]) {
            return ObjectUtils.nullSafeToString((Object[])obj);
        }
        if (obj instanceof boolean[]) {
            return ObjectUtils.nullSafeToString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return ObjectUtils.nullSafeToString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return ObjectUtils.nullSafeToString((char[])obj);
        }
        if (obj instanceof double[]) {
            return ObjectUtils.nullSafeToString((double[])obj);
        }
        if (obj instanceof float[]) {
            return ObjectUtils.nullSafeToString((float[])obj);
        }
        if (obj instanceof int[]) {
            return ObjectUtils.nullSafeToString((int[])obj);
        }
        if (obj instanceof long[]) {
            return ObjectUtils.nullSafeToString((long[])obj);
        }
        if (obj instanceof short[]) {
            return ObjectUtils.nullSafeToString((short[])obj);
        }
        return obj.toString();
    }

    public static String nullSafeToString(Object[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(String.valueOf(array[i]));
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(boolean[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(byte[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(char[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append("'").append(array[i]).append("'");
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(double[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(float[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(int[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(long[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String nullSafeToString(short[] array) {
        if (array == null) {
            return NULL_STRING;
        }
        int length = array.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                buffer.append(ARRAY_START);
            } else {
                buffer.append(ARRAY_ELEMENT_SEPARATOR);
            }
            buffer.append(array[i]);
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return obj.getClass().getName() + "@" + ObjectUtils.getIdentityHexString(obj);
    }

    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static String getDisplayString(Object obj) {
        if (obj == null) {
            return EMPTY_STRING;
        }
        return ObjectUtils.nullSafeToString(obj);
    }

    public static boolean isPrimitive(String typeName) {
        return _primitiveTypes.containsKey(typeName);
    }

    public static Class<?> getPrimitive(String typeName) {
        return _primitiveTypes.get(typeName);
    }

    public static Object getDefaultValue(Class<?> type) {
        return _defaultValues.get(type);
    }

    public static <T> T assertArgumentNotNull(T argument, String argumentName) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument cannot be null - '" + argumentName + "'");
        }
        return argument;
    }
}

