/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import java.util.Properties;

@InternalApi
public class PropertiesUtils {
    protected PropertiesUtils() {
    }

    public static String get(Properties properties, String propertyName) {
        return properties == null ? null : properties.getProperty(propertyName);
    }

    public static boolean getBoolean(Properties properties, String propertyName, boolean defaultValue) {
        String value = PropertiesUtils.get(properties, propertyName);
        return value == null || value.length() == 0 ? defaultValue : Boolean.parseBoolean(value);
    }

    public static short getShort(Properties properties, String propertyName, short defaultValue) {
        String value = PropertiesUtils.get(properties, propertyName);
        return value == null || value.length() == 0 ? defaultValue : Short.parseShort(value);
    }

    public static int getInteger(Properties properties, String propertyName, int defaultValue) {
        String value = PropertiesUtils.get(properties, propertyName);
        return value == null || value.length() == 0 ? defaultValue : Integer.parseInt(value);
    }

    public static long getLong(Properties properties, String propertyName, long defaultValue) {
        String value = PropertiesUtils.get(properties, propertyName);
        return value == null || value.length() == 0 ? defaultValue : Long.parseLong(value);
    }

    public static float getFloat(Properties properties, String propertyName, float defaultValue) {
        String value = PropertiesUtils.get(properties, propertyName);
        return value == null || value.length() == 0 ? defaultValue : Float.parseFloat(value);
    }

    public static double getDouble(Properties properties, String propertyName, double defaultValue) {
        String value = PropertiesUtils.get(properties, propertyName);
        return value == null || value.length() == 0 ? defaultValue : Double.parseDouble(value);
    }

    public static <T extends Enum<T>> T getEnum(Properties properties, String propertyName, Class<T> enumType, T defaultValue) {
        String value = PropertiesUtils.get(properties, propertyName);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Enum.valueOf(enumType, value);
    }
}

