/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class ReflectionUtils {
    private static final Map<String, Class<?>> _primitiveTypes = ReflectionUtils.initPrimitiveTypes();
    private static final Set<String> _spacePrimitiveTypes = ReflectionUtils.initSpacePrimitiveTypes();
    private static final Set<String> _commonJavaTypes = ReflectionUtils.initCommonJavaTypes();
    public static final FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        @Override
        public boolean matches(Field field) {
            return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
        }
    };

    public static boolean isPrimitive(String typeName) {
        return _primitiveTypes.containsKey(typeName);
    }

    public static boolean isPrimitiveAssignable(String typeName, Class<?> type) {
        return type.equals(_primitiveTypes.get(typeName));
    }

    public static boolean isSpacePrimitive(String typeName) {
        if (_spacePrimitiveTypes.contains(typeName)) {
            return true;
        }
        if (typeName.equals(Object.class.getName()) || typeName.equals(Class.class.getName())) {
            return false;
        }
        return typeName.startsWith("java.lang.");
    }

    public static boolean isCommonJavaType(String typeName) {
        return ReflectionUtils.isSpacePrimitive(typeName) || _commonJavaTypes.contains(typeName);
    }

    public static boolean isCommonJavaType(Class<? extends Object> clazz) {
        String name = clazz.getName();
        return ReflectionUtils.isCommonJavaType(name);
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        if (ex.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)ex.getTargetException();
        }
        if (ex.getTargetException() instanceof Error) {
            throw (Error)ex.getTargetException();
        }
        throw new IllegalStateException("Unexpected exception thrown by method - " + ex.getTargetException().getClass().getName() + ": " + ex.getTargetException().getMessage());
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, null);
    }

    public static Object invokeMethod(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Field getDeclaredField(Class<?> type, String fieldName) {
        Field result = null;
        for (Class<?> currentType = type; currentType != null; currentType = currentType.getSuperclass()) {
            try {
                result = currentType.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return result;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static void makeAccessible(Field field) {
        if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
            field.setAccessible(true);
        }
    }

    public static void doWithMethods(Class targetClass, MethodCallback mc) throws IllegalArgumentException {
        ReflectionUtils.doWithMethods(targetClass, mc, null);
    }

    public static void doWithMethods(Class targetClass, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        do {
            Method[] methods = targetClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (mf != null && !mf.matches(methods[i])) continue;
                try {
                    mc.doWith(methods[i]);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + methods[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null);
    }

    public static Method[] getAllDeclaredMethods(Class leafClass) throws IllegalArgumentException {
        final LinkedList l = new LinkedList();
        ReflectionUtils.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method m) {
                l.add(m);
            }
        });
        return l.toArray(new Method[l.size()]);
    }

    public static void doWithFields(Class targetClass, FieldCallback fc) throws IllegalArgumentException {
        ReflectionUtils.doWithFields(targetClass, fc, null);
    }

    public static void doWithFields(Class targetClass, FieldCallback fc, FieldFilter ff) throws IllegalArgumentException {
        do {
            Field[] fields = targetClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (ff != null && !ff.matches(fields[i])) continue;
                try {
                    fc.doWith(fields[i]);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + fields[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), new FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible(field);
                Object srcValue = field.get(src);
                field.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static boolean isNumeric(Class type) {
        return Number.class.isAssignableFrom(type) || type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Float.TYPE || type == Double.TYPE || type == Byte.TYPE;
    }

    private static Map<String, Class<?>> initPrimitiveTypes() {
        HashMap primitiveTypes = new HashMap();
        primitiveTypes.put(Byte.TYPE.getName(), Byte.class);
        primitiveTypes.put(Short.TYPE.getName(), Short.class);
        primitiveTypes.put(Integer.TYPE.getName(), Integer.class);
        primitiveTypes.put(Long.TYPE.getName(), Long.class);
        primitiveTypes.put(Float.TYPE.getName(), Float.class);
        primitiveTypes.put(Double.TYPE.getName(), Double.class);
        primitiveTypes.put(Boolean.TYPE.getName(), Boolean.class);
        primitiveTypes.put(Character.TYPE.getName(), Character.class);
        return primitiveTypes;
    }

    private static Set<String> initSpacePrimitiveTypes() {
        HashSet<String> primitiveTypes = new HashSet<String>();
        primitiveTypes.add(Byte.TYPE.getName());
        primitiveTypes.add(Short.TYPE.getName());
        primitiveTypes.add(Integer.TYPE.getName());
        primitiveTypes.add(Long.TYPE.getName());
        primitiveTypes.add(Float.TYPE.getName());
        primitiveTypes.add(Double.TYPE.getName());
        primitiveTypes.add(Boolean.TYPE.getName());
        primitiveTypes.add(Character.TYPE.getName());
        primitiveTypes.add(Byte.class.getName());
        primitiveTypes.add(Short.class.getName());
        primitiveTypes.add(Integer.class.getName());
        primitiveTypes.add(Long.class.getName());
        primitiveTypes.add(Float.class.getName());
        primitiveTypes.add(Double.class.getName());
        primitiveTypes.add(Boolean.class.getName());
        primitiveTypes.add(Character.class.getName());
        primitiveTypes.add(String.class.getName());
        return primitiveTypes;
    }

    private static Set<String> initCommonJavaTypes() {
        HashSet<String> commonJavaTypes = new HashSet<String>();
        commonJavaTypes.add(BigDecimal.class.getName());
        commonJavaTypes.add(BigInteger.class.getName());
        commonJavaTypes.add(java.util.Date.class.getName());
        commonJavaTypes.add(Calendar.class.getName());
        commonJavaTypes.add(UUID.class.getName());
        commonJavaTypes.add(Date.class.getName());
        commonJavaTypes.add(Timestamp.class.getName());
        commonJavaTypes.add(Time.class.getName());
        commonJavaTypes.add(LocalDateTime.class.getName());
        commonJavaTypes.add(LocalDate.class.getName());
        commonJavaTypes.add(LocalTime.class.getName());
        commonJavaTypes.add(Duration.class.getName());
        commonJavaTypes.add(DayOfWeek.class.getName());
        commonJavaTypes.add(MonthDay.class.getName());
        commonJavaTypes.add(Period.class.getName());
        commonJavaTypes.add(Year.class.getName());
        commonJavaTypes.add(YearMonth.class.getName());
        commonJavaTypes.add(ZonedDateTime.class.getName());
        commonJavaTypes.add(ZoneId.class.getName());
        commonJavaTypes.add(ZoneOffset.class.getName());
        commonJavaTypes.add(Instant.class.getName());
        commonJavaTypes.add(OffsetDateTime.class.getName());
        commonJavaTypes.add(OffsetTime.class.getName());
        return commonJavaTypes;
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

