/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class ReplaceInFileUtils {
    private final String fileName;
    private final StringBuffer sb;

    public ReplaceInFileUtils(String fileName) throws IOException {
        int ch;
        this.fileName = fileName;
        this.sb = new StringBuffer();
        InputStreamReader isr = new InputStreamReader(new FileInputStream(fileName));
        while ((ch = isr.read()) != -1) {
            this.sb.append((char)ch);
        }
        isr.close();
    }

    public static void copyFiles(String[] files, String destPath) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            int ch;
            String fileName = files[i].substring(files[i].lastIndexOf("/"));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(files[i]));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destPath + fileName));
            while ((ch = bis.read()) != -1) {
                bos.write(ch);
            }
            bos.flush();
            bos.close();
            bis.close();
        }
    }

    public static void copyFile(String fileName, String destFileName) throws IOException, FileNotFoundException {
        int ch;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(fileName));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFileName));
        while ((ch = bis.read()) != -1) {
            bos.write(ch);
        }
        bos.flush();
        bos.close();
        bis.close();
    }

    public void replaceInFile(String oldStr, String newStr) throws IOException {
        int next = 0;
        String line = null;
        line = this.sb.toString();
        while ((next = line.indexOf(oldStr, next)) != -1) {
            line = this.sb.replace(next, next + oldStr.length(), newStr).toString();
        }
    }

    public void replaceInFile(String oldStr, String newStr, int fromIndex, boolean isOneIteration) throws IOException {
        int next = 0;
        int indexCounter = 1;
        String line = null;
        if (fromIndex <= 0) {
            fromIndex = 0;
        }
        line = this.sb.toString();
        while ((next = line.indexOf(oldStr, next)) != -1) {
            if (indexCounter >= fromIndex) {
                line = this.sb.replace(next, next + oldStr.length(), newStr).toString();
                if (isOneIteration) {
                    return;
                }
            }
            ++indexCounter;
        }
    }

    public void xmlReplace(String propValue, String replacedValue) {
        String nextToken;
        StringTokenizer st = new StringTokenizer(propValue, ".");
        String str = this.sb.toString();
        int inx = 0;
        String prevToken = null;
        while ((inx = str.indexOf((nextToken = st.nextToken()) + ">", inx)) != -1) {
            while (!str.substring(inx - 1, inx).equals("<") && (inx = str.indexOf(nextToken + ">", inx + 1)) != -1) {
            }
            if (st.hasMoreTokens()) {
                prevToken = nextToken;
            }
            if (st.hasMoreTokens()) continue;
            if (str.indexOf("</" + nextToken, inx) > str.indexOf("</" + prevToken, inx)) {
                return;
            }
            int start = inx + nextToken.length() + 1;
            int end = str.indexOf("</" + nextToken, inx);
            if (start < 0 || end < 0 || start > end) {
                throw new StringIndexOutOfBoundsException("Can't find property \"" + propValue + "\" with start index " + start + " and end index " + end);
            }
            this.sb.replace(start, end, replacedValue);
            return;
        }
    }

    public void close() throws FileNotFoundException {
        PrintStream ps = new PrintStream(new FileOutputStream(this.fileName));
        ps.println(this.sb.toString());
        ps.flush();
        ps.close();
    }

    public static void delTree(String dirName, String excludedDirName) {
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    files[i].delete();
                    continue;
                }
                if (excludedDirName != null && files[i].getPath().equalsIgnoreCase(dir + File.separator + excludedDirName)) continue;
                ReplaceInFileUtils.delTree(files[i].getPath(), excludedDirName);
            }
            dir.delete();
        }
    }
}

