/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.service.ServiceConfigLoader;
import net.jini.config.ConfigurationException;
import net.jini.lease.LeaseRenewalManager;
import net.jini.space.InternalSpaceException;

@InternalApi
public class SharedObjects {
    public static final SharedLeaseRenewalManager LeaseRenewalManager = new SharedLeaseRenewalManager();

    public static class SharedLeaseRenewalManager
    extends SharedObject<LeaseRenewalManager> {
        @Override
        protected LeaseRenewalManager createInstance() {
            try {
                return new LeaseRenewalManager(ServiceConfigLoader.getConfiguration());
            }
            catch (ConfigurationException e) {
                throw new InternalSpaceException("Failed to instantiate shared LeaseRenewalManager", e);
            }
        }

        @Override
        protected void closeInstance(LeaseRenewalManager instance) {
            instance.terminate();
        }
    }

    public static abstract class SharedObject<T> {
        private T _instance;
        private int _references;

        public synchronized T get() {
            if (this._instance == null) {
                this._instance = this.createInstance();
                this._references = 0;
            }
            ++this._references;
            return this._instance;
        }

        public synchronized void release() {
            if (--this._references <= 0 && this._instance != null) {
                this.closeInstance(this._instance);
                this._instance = null;
            }
        }

        protected abstract T createInstance();

        protected abstract void closeInstance(T var1);
    }
}

