/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.internal.io.BootIOUtils;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public abstract class StringUtils {
    public static final String FOLDER_SEPARATOR = "/";
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static String FORMAT_TIME_STAMP = "%1$tF %1$tT.%1$tL";

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean hasLength(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasText(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str != null && suffix != null && str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static int indexOfIgnoreCase(String str1, String str2) {
        int length = str2.length();
        int lastPos = str1.length() - length;
        for (int pos = 0; pos <= lastPos; ++pos) {
            if (!str1.regionMatches(true, pos, str2, 0, length)) continue;
            return pos;
        }
        return -1;
    }

    public static int countOccurrencesOf(String s, char c) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        char[] chars = s.toCharArray();
        int count = 0;
        for (char aChar : chars) {
            if (aChar != c) continue;
            ++count;
        }
        return count;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String join(String[] array, String delimiter, int firstIndex, int count) {
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return array[firstIndex];
            }
            case 2: {
                return array[firstIndex] + delimiter + array[firstIndex + 1];
            }
            case 3: {
                return array[firstIndex] + delimiter + array[firstIndex + 1] + delimiter + array[firstIndex + 2];
            }
            case 4: {
                return array[firstIndex] + delimiter + array[firstIndex + 1] + delimiter + array[firstIndex + 2] + delimiter + array[firstIndex + 3];
            }
            case 5: {
                return array[firstIndex] + delimiter + array[firstIndex + 1] + delimiter + array[firstIndex + 2] + delimiter + array[firstIndex + 3] + delimiter + array[firstIndex + 4];
            }
        }
        StringBuilder sb = new StringBuilder(array[0]);
        for (int i = firstIndex + 1; i < count; ++i) {
            sb.append(delimiter);
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String join(Collection<String> collection, String separator) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : collection) {
            if (sb.length() != 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static List<String> toList(String s, String delimiter) {
        if (s == null || s.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(s, delimiter);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static Properties toProperties(String s, String propertyDelimiter, String keyValueSeparator) {
        Properties properties = new Properties();
        List<String> tokens = StringUtils.toList(s, propertyDelimiter);
        for (String token : tokens) {
            int separatorPos = token.indexOf(keyValueSeparator);
            String key = token.substring(0, separatorPos);
            String value = token.substring(separatorPos + 1);
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtils.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(str.substring(i, i + 1));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(str.substring(pos, delPos));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(str.substring(pos));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return StringUtils.delimitedListToStringArray(str, ",");
    }

    public static String arrayToDelimitedString(Object[] arr, String delim) {
        if (arr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<String> coll, String delim, String prefix, String suffix) {
        if (coll == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = coll.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(prefix).append(it.next()).append(suffix);
            ++i;
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<String> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String arrayToCommaDelimitedString(Object[] arr) {
        return StringUtils.arrayToDelimitedString(arr, ",");
    }

    public static String collectionToCommaDelimitedString(Collection<String> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static Set<String> convertArrayToSet(String[] array) {
        HashSet<String> resultSet = new HashSet<String>(array.length);
        Collections.addAll(resultSet, array);
        return resultSet;
    }

    public static Set<String> getParametersSet(String locatorsStr) {
        if (JSpaceUtilities.isEmpty(locatorsStr, true)) {
            return new HashSet<String>(1);
        }
        String[] locatorsArray = StringUtils.tokenizeToStringArray(locatorsStr, ",");
        return StringUtils.convertArrayToSet(locatorsArray);
    }

    public static void appendProperties(StringBuilder sb, Properties properties) {
        if (properties == null) {
            sb.append("null");
        } else {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                sb.append("\n\t XPath element key: ").append(propName);
                String propValue = properties.getProperty(propName);
                sb.append("\n\t Value: ").append(propValue);
                sb.append('\n');
            }
        }
    }

    public static String[] convertKeyValuePairsToArray(Map<String, String> value, String keyValueSeperator) {
        ArrayList<String> keyValuePairs = new ArrayList<String>();
        for (String pairkey : value.keySet()) {
            String pairvalue = value.get(pairkey);
            if (pairkey.contains(keyValueSeperator)) {
                throw new IllegalArgumentException("Key " + pairkey + " cannot contain separator " + keyValueSeperator);
            }
            keyValuePairs.add(pairkey + keyValueSeperator + pairvalue);
        }
        return keyValuePairs.toArray(new String[keyValuePairs.size()]);
    }

    public static Map<String, String> convertArrayToKeyValuePairs(String[] pairs, String keyValueSeperator) {
        HashMap<String, String> value = new HashMap<String, String>();
        for (String pair : pairs) {
            int sepindex = pair.indexOf(keyValueSeperator);
            String pairkey = pair.substring(0, sepindex);
            String pairvalue = pair.substring(sepindex + 1);
            value.put(pairkey, pairvalue);
        }
        return value;
    }

    public static String getTimeStamp() {
        return StringUtils.getTimeStamp(System.currentTimeMillis());
    }

    public static String getTimeStamp(long timeInMillis) {
        return String.format(FORMAT_TIME_STAMP, timeInMillis);
    }

    public static String getSuffix(String s, String separator) {
        if (!StringUtils.hasLength(s)) {
            return s;
        }
        int lastIndexOf = s.lastIndexOf(separator);
        if (lastIndexOf == -1) {
            return s;
        }
        return s.substring(lastIndexOf + separator.length(), s.length());
    }

    public static String getCurrentStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < stackTrace.length; ++i) {
            sb.append("\tat ").append(stackTrace[i].toString()).append("\n");
        }
        return sb.toString();
    }

    public static boolean isStrictPrefix(String s, String prefix) {
        return s.startsWith(prefix) && s.length() > prefix.length();
    }

    public static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String trimmed = s.trim();
        return trimmed.length() != 0 ? trimmed : null;
    }

    public static void resolvePlaceholders(Properties properties) {
        StringUtils.resolvePlaceholders(properties, System.getenv());
    }

    public static void resolvePlaceholders(Properties properties, Map<String, String> environment) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            properties.put(key, StringUtils.resolvePlaceholders(value, environment));
        }
    }

    public static String resolvePlaceholders(String text) {
        return StringUtils.resolvePlaceholders(text, System.getenv());
    }

    public static String resolvePlaceholders(String text, Map<String, String> environment) {
        return StringUtils.resolvePlaceholders(text, environment, "${", "}");
    }

    public static String resolvePlaceholders(String text, Map<String, String> environment, String prefix, String suffix) {
        if (text == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(text);
        int startIndex = text.indexOf(prefix);
        while (startIndex != -1) {
            int endIndex = buf.toString().indexOf(suffix, startIndex + prefix.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + prefix.length(), endIndex);
                int nextIndex = endIndex + suffix.length();
                try {
                    String propVal = System.getProperty(placeholder);
                    if (propVal == null) {
                        propVal = environment.get(placeholder);
                    }
                    if (propVal == null) {
                        throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property: neither system property nor environment variable found");
                    }
                    buf.replace(startIndex, endIndex + suffix.length(), propVal);
                    nextIndex = startIndex + propVal.length();
                }
                catch (Throwable ex) {
                    throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in [" + text + "] as system property", ex);
                }
                startIndex = buf.toString().indexOf(prefix, nextIndex);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    public static Long parseStringAsBytes(String property) {
        return BootIOUtils.parseStringAsBytes((String)property);
    }

    public static Long parseDurationAsMillis(String property) {
        int pos;
        if (property == null || property.length() == 0) {
            return null;
        }
        for (pos = 0; pos < property.length() && Character.isDigit(property.charAt(pos)); ++pos) {
        }
        String prefix = property.substring(0, pos);
        long number = Long.parseLong(prefix);
        String suffix = pos < property.length() ? property.substring(pos) : null;
        TimeUnit timeUnit = StringUtils.parseTimeUnit(suffix, TimeUnit.MILLISECONDS);
        return timeUnit.toMillis(number);
    }

    public static TimeUnit parseTimeUnit(String s, TimeUnit defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        if (s.equalsIgnoreCase("n")) {
            return TimeUnit.NANOSECONDS;
        }
        if (s.equalsIgnoreCase("u")) {
            return TimeUnit.MICROSECONDS;
        }
        if (s.equalsIgnoreCase("ms")) {
            return TimeUnit.MILLISECONDS;
        }
        if (s.equalsIgnoreCase("s")) {
            return TimeUnit.SECONDS;
        }
        if (s.equalsIgnoreCase("m")) {
            return TimeUnit.MINUTES;
        }
        if (s.equalsIgnoreCase("h")) {
            return TimeUnit.HOURS;
        }
        if (s.equalsIgnoreCase("d")) {
            return TimeUnit.DAYS;
        }
        throw new IllegalArgumentException("Invalid time unit: '" + s + "'");
    }
}

