/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.Textualizable;

@InternalApi
public class Textualizer {
    private final StringBuilder _sb = new StringBuilder();
    private boolean _hasProperties;

    public static String toString(Textualizable textualizable) {
        Textualizer textualizer = new Textualizer();
        textualizer.appendValue(textualizable);
        return textualizer._sb.toString();
    }

    private Textualizer() {
    }

    public Textualizer appendValue(Object value) {
        if (value == null) {
            this._sb.append("null");
        } else if (value instanceof Textualizable) {
            boolean hasProperties = this._hasProperties;
            this._hasProperties = false;
            this._sb.append(value.getClass().getSimpleName());
            this._sb.append('[');
            ((Textualizable)value).toText(this);
            this._sb.append(']');
            this._hasProperties = hasProperties;
        } else if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            this._sb.append('{');
            if (array.length > 0) {
                this._sb.append(array[0]);
                for (int i = 1; i < array.length; ++i) {
                    this._sb.append(',').append(array[i]);
                }
            }
            this._sb.append('}');
        } else {
            this._sb.append(value);
        }
        return this;
    }

    public Textualizer append(String name, Object value) {
        this.appendPropertiesSeparator();
        this._sb.append(name);
        this._sb.append('=');
        this.appendValue(value);
        return this;
    }

    public Textualizer appendIfNotNull(String name, Object value) {
        return value == null ? this : this.append(name, value);
    }

    private void appendPropertiesSeparator() {
        if (this._hasProperties) {
            this._sb.append(',');
        } else {
            this._hasProperties = true;
        }
    }

    public Textualizer appendString(String str) {
        this._sb.append(str);
        return this;
    }

    public Textualizer appendNewLine(String name, Object value) {
        this._sb.append(StringUtils.NEW_LINE);
        this._sb.append(name);
        this._sb.append('=');
        this.appendValue(value);
        return this;
    }

    public void appendIterable(String name, Iterable<?> iterable) {
        this.appendPropertiesSeparator();
        this._sb.append(name);
        this._sb.append("=[");
        for (Object object : iterable) {
            this.appendValue(object);
        }
        this._sb.append(']');
    }
}

