/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@InternalApi
public class ThreadDumpUtility {
    public static String generateThreadDumpIfPossible() {
        try {
            return ThreadDumpUtility.generateThreadDump();
        }
        catch (Exception e) {
            return "Error creating thread dump " + e.getMessage();
        }
    }

    public static String generateThreadDump() throws Exception {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        StringBuilder dump = new StringBuilder();
        ThreadDumpUtility.processDeadlocks(dump, threadBean);
        ThreadDumpUtility.processAllThreads(dump, threadBean);
        return dump.toString();
    }

    private static void processAllThreads(StringBuilder dump, ThreadMXBean threadBean) throws Exception {
        dump.append(StringUtils.NEW_LINE);
        dump.append("===== All Threads =====");
        dump.append(StringUtils.NEW_LINE);
        ThreadDumpUtility.dumpThreads(dump, ThreadDumpUtility.dumpAllThreads(threadBean));
    }

    private static ThreadInfo[] dumpAllThreads(ThreadMXBean threadBean) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = threadBean.getClass().getDeclaredMethod("dumpAllThreads", Boolean.TYPE, Boolean.TYPE);
        method.setAccessible(true);
        return (ThreadInfo[])method.invoke((Object)threadBean, true, true);
    }

    private static ThreadInfo[] getThreadInfo(long[] threadIds, ThreadMXBean threadBean) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = threadBean.getClass().getDeclaredMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
        method.setAccessible(true);
        return (ThreadInfo[])method.invoke((Object)threadBean, threadIds, true, true);
    }

    private static long[] findDeadlockedThreads(ThreadMXBean threadBean) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = threadBean.getClass().getDeclaredMethod("findDeadlockedThreads", new Class[0]);
        method.setAccessible(true);
        return (long[])method.invoke((Object)threadBean, new Object[0]);
    }

    private static void processDeadlocks(StringBuilder dump, ThreadMXBean threadBean) throws Exception {
        dump.append("=====  Deadlocked Threads =====");
        dump.append(StringUtils.NEW_LINE);
        long[] deadlockedThreadIds = ThreadDumpUtility.findDeadlockedThreads(threadBean);
        if (deadlockedThreadIds != null) {
            ThreadDumpUtility.dumpThreads(dump, ThreadDumpUtility.getThreadInfo(deadlockedThreadIds, threadBean));
        }
    }

    private static void dumpThreads(StringBuilder dump, ThreadInfo[] infos) throws Exception {
        for (ThreadInfo info : infos) {
            dump.append(StringUtils.NEW_LINE);
            ThreadDumpUtility.write(info, dump);
        }
    }

    private static void write(ThreadInfo threadInfo, StringBuilder dump) throws Exception {
        StackTraceElement[] stackTraceElements;
        dump.append(String.format("\"%s\" Id=%s %s", new Object[]{threadInfo.getThreadName(), threadInfo.getThreadId(), threadInfo.getThreadState()}));
        if (threadInfo.getLockName() != null) {
            dump.append(String.format(" on %s", threadInfo.getLockName()));
            if (threadInfo.getLockOwnerName() != null) {
                dump.append(String.format(" owned by \"%s\" Id=%s", threadInfo.getLockOwnerName(), threadInfo.getLockOwnerId()));
            }
        }
        if (threadInfo.isInNative()) {
            dump.append(" (in native)");
        }
        dump.append(StringUtils.NEW_LINE);
        Class<?> monitorInfoClass = Class.forName("java.lang.management.MonitorInfo", true, ThreadDumpUtility.class.getClassLoader());
        Method getLockedStackFrameMethod = monitorInfoClass.getMethod("getLockedStackFrame", new Class[0]);
        getLockedStackFrameMethod.setAccessible(true);
        Method getClassNameMethod = monitorInfoClass.getMethod("getClassName", new Class[0]);
        getClassNameMethod.setAccessible(true);
        Method getIdentityHashCodeMethod = monitorInfoClass.getMethod("getIdentityHashCode", new Class[0]);
        getIdentityHashCodeMethod.setAccessible(true);
        Method lockedMonitorsMethod = ThreadInfo.class.getDeclaredMethod("getLockedMonitors", new Class[0]);
        lockedMonitorsMethod.setAccessible(true);
        Object[] lockedMonitors = (Object[])lockedMonitorsMethod.invoke((Object)threadInfo, new Object[0]);
        for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
            dump.append("    at " + stackTraceElement);
            dump.append(StringUtils.NEW_LINE);
            Object lockedMonitor = ThreadDumpUtility.findLockedMonitor(stackTraceElement, lockedMonitors, getLockedStackFrameMethod);
            if (lockedMonitor == null) continue;
            dump.append("    - locked " + getClassNameMethod.invoke(lockedMonitor, new Object[0]) + "@" + getIdentityHashCodeMethod.invoke(lockedMonitor, new Object[0]));
            dump.append(StringUtils.NEW_LINE);
        }
    }

    private static Object findLockedMonitor(StackTraceElement stackTraceElement, Object[] lockedMonitors, Method getLockedStackFrameMethod) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Object monitorInfo : lockedMonitors) {
            if (!stackTraceElement.equals(getLockedStackFrameMethod.invoke(monitorInfo, new Object[0]))) continue;
            return monitorInfo;
        }
        return null;
    }
}

