/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class TreeNode<T> {
    private T _data;
    private final TreeNode<T> _parent;
    private final List<TreeNode<T>> _children;

    public TreeNode(T data, TreeNode<T> parent) {
        this._data = data;
        this._parent = parent;
        this._children = new ArrayList<TreeNode<T>>();
        if (parent != null) {
            parent._children.add(this);
        }
    }

    public T getData() {
        return this._data;
    }

    public void setData(T data) {
        this._data = data;
    }

    public TreeNode<T> getParent() {
        return this._parent;
    }

    public List<TreeNode<T>> getChildren() {
        return this._children;
    }

    public List<T> buildParentHierarchy() {
        ArrayList<T> result = new ArrayList<T>();
        TreeNode<T> node = this;
        while (node != null) {
            result.add(node._data);
            node = node._parent;
        }
        return result;
    }

    public List<T> buildBFS() {
        ArrayList<T> result = new ArrayList<T>();
        LinkedList<TreeNode<T>> queue = new LinkedList<TreeNode<T>>();
        result.add(this._data);
        queue.addFirst(this);
        while (!queue.isEmpty()) {
            TreeNode currentNode = (TreeNode)queue.getFirst();
            for (TreeNode<T> childNode : currentNode._children) {
                result.add(childNode._data);
                queue.addLast(childNode);
            }
            queue.removeFirst();
        }
        return result;
    }
}

