/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.security.authorities.GridAuthority;
import com.j_spaces.core.exception.InvalidServiceNameException;

@InternalApi
public class ValidationUtils {
    private static final char[] INVALID_CHARACTERS_ARRAY = new char[]{'>', '<', ',', '\"', '\'', '&', '\\', '!', '@', '#', '$', '%', '^', '*', '~', '+', ')', '('};
    private static final String INVALID_CHARACTERS_STR;
    private static final String INVALID_CHARACTERS_MESSAGE_SUFFIX = " cannot contain a space or any of the following characters:";
    private static final String INVALID_DIGITS_MESSAGE_SUFFIX = " cannot start with digits.";
    public static final String MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM;
    public static final String MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM_ALREADY_LOOGED_IN;
    private static final String MSG_UNABLE_TO_DEPLOY_READ_ONLY_GSM;
    private static final String MSG_UNABLE_TO_DEPLOY_USER_DOES_NOT_EXIST = "Unable to perform deployment. Authentication failed.";
    public static final String MSG_UNABLE_TO_RELOCATE_PREFIX = "You do not have sufficient permissions to relocate the processing unit instance ";
    public static final String MSG_UNABLE_TO_RELOCATE_SUFFIX;
    public static final String MSG_UNABLE_TO_RELOCATE_LOGIN_SUFFIX = "Do you wish to login?";
    public static final String MSG_UNABLE_TO_RELOCATE_LOGIN_AS_DIFFERENT_USER_SUFFIX = "Do you wish to login as a different user?";
    public static final String MSG_UNABLE_TO_DEPLOY_SINGLE_SPACE;

    public static void checkServiceNameForValidation(String serviceNameVal, String name) throws InvalidServiceNameException {
        if (serviceNameVal.indexOf(32) >= 0 || ValidationUtils.isStringHasInvalidCharacters(serviceNameVal)) {
            String exceptionMessage = name + INVALID_CHARACTERS_MESSAGE_SUFFIX + "\n" + INVALID_CHARACTERS_STR + ".";
            if (ValidationUtils.isSringStartsWithNumber(serviceNameVal)) {
                exceptionMessage = ValidationUtils.createInvalidDigitsAndCharactersMessage(name);
            }
            throw new InvalidServiceNameException(exceptionMessage);
        }
        if (ValidationUtils.isSringStartsWithNumber(serviceNameVal)) {
            String exceptionMessage = name + INVALID_DIGITS_MESSAGE_SUFFIX;
            throw new InvalidServiceNameException(exceptionMessage);
        }
    }

    public static boolean isStringHasInvalidCharacters(String str) {
        for (int i = 0; i < INVALID_CHARACTERS_ARRAY.length; ++i) {
            char invalidChar = INVALID_CHARACTERS_ARRAY[i];
            if (str.indexOf(invalidChar) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isSringStartsWithNumber(String str) {
        try {
            String firstChar = str.substring(0, 1);
            Integer.parseInt(firstChar);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static String createInvalidDigitsAndCharactersMessage(String name) {
        StringBuilder strBuffer = new StringBuilder(name);
        strBuffer.append(INVALID_CHARACTERS_MESSAGE_SUFFIX);
        strBuffer.append("\n");
        strBuffer.append(INVALID_CHARACTERS_STR);
        strBuffer.append(".\n");
        strBuffer.append(name);
        strBuffer.append(INVALID_DIGITS_MESSAGE_SUFFIX);
        return strBuffer.toString();
    }

    static {
        MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM = "You are unauthorized to deploy onto a secured GSM without the <" + GridAuthority.GridPrivilege.PROVISION_PU + "> permission. Do you wish to login?";
        MSG_UNABLE_TO_DEPLOY_THEN_LOGIN_TO_GSM_ALREADY_LOOGED_IN = "You are unauthorized to deploy onto a secured GSM without the <" + GridAuthority.GridPrivilege.PROVISION_PU + "> permission.\nPlease login as a different user.";
        MSG_UNABLE_TO_DEPLOY_READ_ONLY_GSM = "Authentication failure. Unable to deploy processing unit without the <" + GridAuthority.GridPrivilege.PROVISION_PU + "> permission.";
        MSG_UNABLE_TO_RELOCATE_SUFFIX = "This operation requires the &lt;" + GridAuthority.GridPrivilege.MANAGE_PU + "&gt; permission.";
        MSG_UNABLE_TO_DEPLOY_SINGLE_SPACE = "Unable to deploy space; User lacks [" + GridAuthority.GridPrivilege.PROVISION_PU + "] privileges for available GSMs.";
        StringBuilder strBuffer = new StringBuilder();
        for (int i = 0; i < INVALID_CHARACTERS_ARRAY.length; ++i) {
            strBuffer.append(INVALID_CHARACTERS_ARRAY[i]);
            strBuffer.append(' ');
        }
        INVALID_CHARACTERS_STR = strBuffer.toString();
    }
}

