/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.start.SystemInfo;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.jini.rio.boot.BootUtil;

@InternalApi
public class XapRuntimeReporter {
    private final List<String> lines = new ArrayList<String>();
    private int width = 0;

    protected void append(String line) {
        this.lines.add(line);
        if (line.length() > this.width) {
            this.width = line.length();
        }
    }

    private void clear() {
        this.lines.clear();
        this.width = 0;
    }

    public String generate(boolean verbose, String title, char sepChar, int maxWidth) {
        this.clear();
        this.appendRuntimeInformation(verbose);
        return this.format(title, sepChar, maxWidth);
    }

    protected void appendRuntimeInformation(boolean verbose) {
        this.appendGigaSpacesPlatformInfo();
        this.appendJavaDetails();
        this.appendSystemDetails();
        this.appendNetworkInfo();
        if (verbose) {
            this.appendEnvironmentVariables();
            this.appendSystemProperties();
        }
    }

    protected String format(String title, char sepChar, int maxWidth) {
        StringBuilder sb = new StringBuilder();
        int width = Math.min(this.width, maxWidth);
        sb.append("\n");
        XapRuntimeReporter.appendSeparator(sb, sepChar, " " + title + " ", width);
        for (String line : this.lines) {
            sb.append(line).append("\n");
        }
        XapRuntimeReporter.append(sb, sepChar, width);
        return sb.toString();
    }

    protected void appendGigaSpacesPlatformInfo() {
        SystemInfo systemInfo = SystemInfo.singleton();
        this.append(PlatformVersion.getOfficialVersion());
        this.append("    Home: " + systemInfo.getXapHome());
        this.append("    Lookup Groups: " + systemInfo.lookup().groups());
        if (systemInfo.getManagerClusterInfo().isEmpty()) {
            String locators = systemInfo.lookup().locators();
            this.append("    Lookup Locators: " + (locators != null ? locators : ""));
        } else {
            this.append("    Manager Servers: " + systemInfo.getManagerClusterInfo().toString());
        }
        String communicationFilterFactory = System.getProperty("com.gs.lrmi.filter.factory", null);
        if (communicationFilterFactory != null) {
            this.append("    Communication Filter Factory: " + communicationFilterFactory);
        }
    }

    protected void appendJavaDetails() {
        this.append("Java:");
        this.append("    Java Runtime: " + System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version") + " (" + System.getProperty("java.vendor") + ")");
        this.append("    Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
        this.append("    Java Home: " + System.getProperty("java.home"));
        Runtime rt = Runtime.getRuntime();
        long maxHeapBytes = rt.maxMemory();
        long currHeapBytes = rt.totalMemory();
        long freeHeapBytes = rt.freeMemory();
        long usedHeapBytes = currHeapBytes - freeHeapBytes;
        this.append("    Memory: " + this.bytesToString("Currently used ", usedHeapBytes) + ", " + this.bytesToString("Current heap size ", currHeapBytes) + ", " + this.bytesToString("Max heap size ", maxHeapBytes));
    }

    protected void appendSystemDetails() {
        this.append("Operating System: " + System.getProperty("os.name") + " [version=" + System.getProperty("os.version") + ", architecture=" + System.getProperty("os.arch") + ", processors=" + Runtime.getRuntime().availableProcessors() + "]");
        this.append("Process Id: " + SystemInfo.singleton().os().processId());
    }

    protected void appendNetworkInfo() {
        this.append("Network:");
        try {
            NetworkInterface[] networkInterfaces;
            this.append("    Local Host: [" + SystemInfo.singleton().network().getHost() + "] ");
            if (!SystemInfo.singleton().network().getPublicHost().getHostAddress().equals(SystemInfo.singleton().network().getHost().getHostAddress())) {
                this.append("    Public Host: [" + SystemInfo.singleton().network().getPublicHost() + "] ");
            }
            for (NetworkInterface networkInterface : networkInterfaces = BootUtil.getNetworkInterfaces()) {
                String desc = this.toString(networkInterface);
                if (desc == null) continue;
                this.append(desc);
            }
        }
        catch (Exception e) {
            this.append("Failed to get Network Interface Info: " + e.getMessage());
        }
    }

    protected void appendSystemProperties() {
        this.appendMap(System.getProperties(), "System properties");
    }

    protected void appendEnvironmentVariables() {
        this.appendMap(System.getenv(), "Environment variables");
    }

    protected void appendMap(Map map, String title) {
        this.append(title + " (total=" + map.size() + "):");
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            this.append("    " + key + "=" + map.get(key));
        }
    }

    protected String bytesToString(String prefix, long sizeInBytes) {
        return prefix + sizeInBytes / 1000000L + "MB";
    }

    protected String toString(NetworkInterface networkInterface) {
        Enumeration<InetAddress> addressesEnum = networkInterface.getInetAddresses();
        if (addressesEnum.hasMoreElements()) {
            StringBuilder sb = new StringBuilder();
            sb.append("    " + networkInterface.getName() + ": " + networkInterface.getDisplayName());
            sb.append(" [IP addresses: ");
            while (addressesEnum.hasMoreElements()) {
                sb.append(addressesEnum.nextElement().getHostAddress()).append(" | ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
            return sb.toString();
        }
        return null;
    }

    private static void appendSeparator(StringBuilder sb, char c, String message, int length) {
        int tempLength = (length - message.length()) / 2;
        XapRuntimeReporter.append(sb, c, tempLength);
        sb.append(message);
        XapRuntimeReporter.append(sb, c, tempLength);
        if (tempLength + message.length() + tempLength < length) {
            sb.append(c);
        }
        sb.append("\n");
    }

    private static void append(StringBuilder sb, char c, int times) {
        for (int i = 0; i < times; ++i) {
            sb.append(c);
        }
    }
}

