/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.collections;

import com.gigaspaces.api.InternalApi;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@InternalApi
public class BasedHashSet<E>
implements Set<E> {
    private final Map<E, Object> map;
    private static final Object PRESENT = new Object();

    public BasedHashSet(Map<E, Object> map) {
        this.map = map;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        if (o == null) {
            return false;
        }
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object element : c) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object element : c) {
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.map.toString();
    }
}

