/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.collections;

import com.gigaspaces.api.InternalApi;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class ConcurrentBoundedCache<Key, Value>
implements Map<Key, Value> {
    protected volatile ConcurrentHashMap<Key, SoftReference<Value>> _map;
    protected AtomicInteger approximateSize = new AtomicInteger(0);
    protected static final Object clearLock = new Object();
    protected static final Object lazyLock = new Object();
    protected static final long upperBound = Long.getLong("com.gs.queryCache.cacheSize", 1000L);
    protected static final boolean enabled = upperBound > 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this._map == null) {
            Object object = lazyLock;
            synchronized (object) {
                if (this._map == null) {
                    this._map = new ConcurrentHashMap();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value put(Key key, Value value) {
        SoftReference<Value> wrappedValue;
        SoftReference<Value> prev;
        if (!enabled) {
            return null;
        }
        this.initialize();
        if ((long)this.approximateSize.getAndIncrement() >= upperBound) {
            Object object = clearLock;
            synchronized (object) {
                if ((long)this.approximateSize.get() >= upperBound) {
                    this.clear();
                    this.approximateSize.set(1);
                }
            }
        }
        if ((prev = this._map.putIfAbsent(key, wrappedValue = new SoftReference<Value>(value))) != null) {
            return prev.get();
        }
        return null;
    }

    @Override
    public Value get(Object key) {
        if (!enabled) {
            return null;
        }
        this.initialize();
        SoftReference<Value> valueSoftReference = this._map.get(key);
        if (valueSoftReference != null) {
            return valueSoftReference.get();
        }
        return null;
    }

    @Override
    public Value remove(Object key) {
        if (!enabled) {
            return null;
        }
        this.initialize();
        SoftReference<Value> remove = this._map.remove(key);
        this.approximateSize.decrementAndGet();
        if (remove != null) {
            return remove.get();
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!enabled) {
            return false;
        }
        return this._map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        if (!enabled) {
            return true;
        }
        return this._map.isEmpty();
    }

    @Override
    public Set<Key> keySet() {
        if (!enabled) {
            return Collections.emptySet();
        }
        return this._map.keySet();
    }

    @Override
    public int size() {
        if (!enabled) {
            return 0;
        }
        return this._map.size();
    }

    @Override
    public void clear() {
        if (!enabled) {
            return;
        }
        this._map = new ConcurrentHashMap();
        this.approximateSize.set(0);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Key, Value>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Key, ? extends Value> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Value> values() {
        throw new UnsupportedOperationException();
    }
}

