/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.collections;

import com.gigaspaces.api.InternalApi;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class CopyOnUpdateOnceMap<K, V>
implements ConcurrentMap<K, V> {
    private Map<K, V> _map = new HashMap();

    @Override
    public void clear() {
        this._map = new HashMap();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this._map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this._map.keySet();
    }

    @Override
    public synchronized V put(K key, V value) {
        Map<K, V> copyMap = this.copyMap();
        V put = copyMap.put(key, value);
        this._map = copyMap;
        return put;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        Map<? extends K, ? extends V> copyMap = this.copyMap();
        copyMap.putAll(t);
        this._map = copyMap;
    }

    @Override
    public synchronized V remove(Object key) {
        Map<K, V> copyMap = this.copyMap();
        V remove = copyMap.remove(key);
        this._map = copyMap;
        return remove;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<V> values() {
        return this._map.values();
    }

    private Map<K, V> copyMap() {
        return new HashMap<K, V>(this._map);
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V v = this._map.get(key);
        if (v == null) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.put(key, value);
            this._map = copyMap;
        }
        return v;
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        V v = this._map.get(key);
        if (v != null && v.equals(value)) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.remove(key);
            this._map = copyMap;
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K key, V value) {
        V v = this._map.get(key);
        if (v != null) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.put(key, value);
            this._map = copyMap;
        }
        return v;
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        V v = this._map.get(key);
        if (v != null && v.equals(oldValue)) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.put(key, newValue);
            this._map = copyMap;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._map.toString();
    }
}

