/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.collections;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class SelfCleaningTable<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<KeyHolder<K>, V> _table;
    private final ReferenceQueue<K> _freeEntryQueue;
    private final Cleaner<K, V> _cleanerThread;
    private final String _name;

    public SelfCleaningTable(String name) {
        this(name, null);
    }

    public SelfCleaningTable(String name, ICleanerListener<V> cleanerListener) {
        this(name, cleanerListener, new ConcurrentHashMap());
    }

    public SelfCleaningTable(String name, ICleanerListener<V> cleanerListener, ConcurrentMap underlyingMap) {
        this._name = name;
        this._table = underlyingMap;
        this._freeEntryQueue = new ReferenceQueue();
        this._cleanerThread = new Cleaner<K, V>(this._name + "-SelfCleaningTable", this._freeEntryQueue, this._table, cleanerListener);
        this._cleanerThread.setContextClassLoader(null);
        this._cleanerThread.start();
    }

    @Override
    public void clear() {
        this._table.clear();
    }

    @Override
    public V put(K key, V value) {
        return this._table.put(this.createKeyHolder(key, this._freeEntryQueue), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        TemplateKeyHolder<Object> templateKeyHolder = TemplateKeyHolder.getTemplateKeyHolder(key);
        try {
            Object v = this._table.get(templateKeyHolder);
            return v;
        }
        finally {
            templateKeyHolder.set(null);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public void close() {
        this._cleanerThread.interrupt();
        this._table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        TemplateKeyHolder<Object> templateKeyHolder = TemplateKeyHolder.getTemplateKeyHolder(key);
        try {
            boolean bl = this._table.containsKey(templateKeyHolder);
            return bl;
        }
        finally {
            templateKeyHolder.set(null);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return this._table.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this._table.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        TemplateKeyHolder<Object> templateKeyHolder = TemplateKeyHolder.getTemplateKeyHolder(key);
        try {
            Object v = this._table.remove(templateKeyHolder);
            return v;
        }
        finally {
            templateKeyHolder.set(null);
        }
    }

    @Override
    public int size() {
        return this._table.size();
    }

    @Override
    public Collection<V> values() {
        return this._table.values();
    }

    private KeyHolder<K> createKeyHolder(K key, ReferenceQueue<K> freeEntryQueue) {
        return new DataKeyHolder<K>(key, freeEntryQueue);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this._table.putIfAbsent(this.createKeyHolder(key, this._freeEntryQueue), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        TemplateKeyHolder<Object> templateKeyHolder = TemplateKeyHolder.getTemplateKeyHolder(key);
        try {
            boolean bl = this._table.remove(templateKeyHolder, value);
            return bl;
        }
        finally {
            templateKeyHolder.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        TemplateKeyHolder<K> templateKeyHolder = TemplateKeyHolder.getTemplateKeyHolder(key);
        try {
            V v = this._table.replace(templateKeyHolder, value);
            return v;
        }
        finally {
            templateKeyHolder.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        TemplateKeyHolder<K> templateKeyHolder = TemplateKeyHolder.getTemplateKeyHolder(key);
        try {
            boolean bl = this._table.replace(templateKeyHolder, oldValue, newValue);
            return bl;
        }
        finally {
            templateKeyHolder.set(null);
        }
    }

    public String toString() {
        return this._table.toString();
    }

    private static class TemplateKeyHolder<T>
    implements KeyHolder<T> {
        private static final ThreadLocal<TemplateKeyHolder> _holderCache = new ThreadLocal<TemplateKeyHolder>(){

            @Override
            protected TemplateKeyHolder initialValue() {
                return new TemplateKeyHolder();
            }
        };
        private T _referent;

        public static <T> TemplateKeyHolder<T> getTemplateKeyHolder(T referent) {
            TemplateKeyHolder holder = _holderCache.get();
            holder.set(referent);
            return holder;
        }

        private TemplateKeyHolder() {
        }

        @Override
        public T get() {
            return this._referent;
        }

        public void set(T referent) {
            this._referent = referent;
        }

        public String toString() {
            return "" + this._referent;
        }

        public boolean equals(Object keyHolder) {
            Object otherValue;
            if (keyHolder == this) {
                return true;
            }
            T value = this.get();
            return value == (otherValue = ((KeyHolder)keyHolder).get()) || value != null && value.equals(otherValue);
        }

        public int hashCode() {
            return this._referent == null ? 13 : this._referent.hashCode();
        }
    }

    private static class DataKeyHolder<T>
    extends WeakReference<T>
    implements KeyHolder<T> {
        final int _hashCode;

        public DataKeyHolder(T referent, ReferenceQueue<T> queue) {
            super(referent, queue);
            this._hashCode = referent == null ? 13 : referent.hashCode();
        }

        public DataKeyHolder(T referent) {
            super(referent);
            this._hashCode = referent == null ? 13 : referent.hashCode();
        }

        public String toString() {
            return "" + this.get();
        }

        public boolean equals(Object keyHolder) {
            Object otherValue;
            if (keyHolder == this) {
                return true;
            }
            Object value = this.get();
            return value == (otherValue = ((KeyHolder)keyHolder).get()) || value != null && value.equals(otherValue);
        }

        public int hashCode() {
            return this._hashCode;
        }
    }

    private static final class Cleaner<K, V>
    extends GSThread {
        private final ReferenceQueue<K> _queue;
        private final Map<KeyHolder<K>, V> _table;
        private final ICleanerListener<V> _listener;

        public Cleaner(String parentName, ReferenceQueue<K> queue, Map<KeyHolder<K>, V> entryInfos, ICleanerListener<V> listener) {
            super(parentName + "$Cleaner");
            this._queue = queue;
            this._table = entryInfos;
            this._listener = listener;
            this.setDaemon(true);
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    KeyHolder ref = (KeyHolder)((Object)this._queue.remove());
                    V removed = this._table.remove(ref);
                    if (this._listener == null || removed == null) continue;
                    this._listener.weakEntryRemoved(removed);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    break;
                }
            }
        }
    }

    public static interface ICleanerListener<V> {
        public void weakEntryRemoved(V var1);
    }

    private static interface KeyHolder<T> {
        public T get();
    }
}

